/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphAreaLine.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphAreaLine.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;

/**
 * 
 */
public class GraphAreaLine extends GraphAreaXY {
	static final long serialVersionUID = -5686103158214358146L;
	/**
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 */
	public GraphAreaLine(Chart input, boolean isLTR, double x, double y, double width, double height, SVGColorPalettes palettes, SVGShapes shapes) {
		super(input, isLTR, x, y, width, height);
		
		this.palettes = palettes;
		this.shapes = shapes;
				
		indepAxisPosition = POSITION_SOUTH;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartXYGraphArea#getPlotArea()
	 */
	protected PlotArea getPlotArea(double x, double y, double width, double height) {
		PlotAreaLine plotarea = new PlotAreaLine(input, isLTR, x, y, width, height, palettes, shapes, useCategories, nls);
		plotarea.setPrimaryDataSets(primaryDataSets);
		plotarea.setSecondaryDataSets(secondaryDataSets);
		plotarea.setPrimaryDepAxis(primaryDepAxis);
		plotarea.setSecondaryDepAxis(secondaryDepAxis);
		plotarea.setIndepAxis(indepAxis);
		return plotarea;
	}

}
