/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphAreaPie.java,v 1.4 2008/12/12 22:22:09 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphAreaPie.java,v 1.4 2008/12/12 22:22:09 jcayne Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

 
import java.util.List;
import java.util.Vector;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Axes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Internationalization;

import com.ibm.icu.util.ULocale;


/**
 * <code>GraphAreaPie</code> is class to add meter graph area in meter chart.
 *
  
 * $Revision: 1.4 $  
 */
public class GraphAreaPie extends GraphArea {
	static final long serialVersionUID = 3930128815728101616L;
	protected List primaryDataSets = null;
	protected boolean useCategories;
	protected List datasetList = null;

	/**
	 * locale
	 */
	protected ULocale locale = null;
	
	/**
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 */
	public GraphAreaPie(
		Chart input, 
		double x, 
		double y, 
		double width, 
		double height,
		SVGColorPalettes palettes) {
		super(input, x, y, width, height);
		this.palettes = palettes;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartGraphArea#getPlotArea()
	 */
	protected PlotArea getPlotArea(double x, double y, double width, double height) {
		analyzeData();
		PlotAreaPie plotarea = new PlotAreaPie(input, 0.0, 0.0, width, height, palettes, locale, nls);
		plotarea.setPrimaryDataSets(primaryDataSets);
		return plotarea;
	}

	/**
	 * 
	 */
	protected void analyzeData() {
		Data data = input.getData();
		if (data != null) {
			DataSets datasets = data.getDataSets();
			if (data.getCategories() != null) {
				useCategories = true;
			} else {
				useCategories = false;
			}
			if (datasets != null) {
				datasetList = datasets.getDataSet();
				primaryDataSets = new Vector(datasetList);
				if (datasetList.isEmpty() == false) {
					DataSet dataset = (DataSet) datasetList.get(0);
				}
			}
		}
		
		Configuration config = input.getConfiguration();
		Axes axes = null;

		// get axis definition		
		if (config != null) {
			// get locale settings
			Internationalization i18n = config.getInternationalization();
			if (i18n != null) {
				String language = i18n.getLanguage() == null ? EMPTY_STRING : i18n.getLanguage();
				String country = i18n.getCountry() == null ? EMPTY_STRING : i18n.getCountry();
				if ((language != EMPTY_STRING) && (country != EMPTY_STRING))
					locale = new ULocale(language, country);
				else if (language != EMPTY_STRING)
					locale = new ULocale(language);
				
			}
		}		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		SVGBase[] parts = new SVGBase[1];
		setChildren(parts);
		parts[0] = getPlotArea(x, y, width, height);
	}
}
