/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphAreaPie3D.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphAreaPie3D.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;

/**
 * <code>GraphAreaPie3D</code> class constructs a typical pie chart in 3-D space.  The 
 * data points within the plot area are displayed in a 3-D perspective.
 */
public class GraphAreaPie3D extends GraphAreaPie {
	static final long serialVersionUID = 507870449201211216L;
	/**
     * Constructor for GraphAreaPie3D.
     * @param input
     * @param x
     * @param y
     * @param width
     * @param height
     * @param palettes
     */
    public GraphAreaPie3D(Chart input, double x, double y, double width,
        double height, SVGColorPalettes palettes) {
        super(input, x, y, width, height, palettes);
    }

    /**
     * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.GraphAreaPie#getPlotArea(double, double, double, double)
     */
    protected PlotArea getPlotArea(double x, double y, double width,
        double height) {
        analyzeData();

        PlotAreaPie plotarea = new PlotAreaPie3D(input, 0.0, 0.0, width,
                height, palettes, locale, nls);
        plotarea.setPrimaryDataSets(primaryDataSets);

        return plotarea;
    }
}
