/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphAreaStackArea.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphAreaStackArea.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;

/**
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class GraphAreaStackArea extends GraphAreaXY {
	static final long serialVersionUID = -650683973463235669L;
	/**
	 * @param input
	 * @param isLTR
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 * @param palettes
	 * @param shapes
	 */
	public GraphAreaStackArea(Chart input, boolean isLTR, double x, double y, double width, double height, SVGColorPalettes palettes, SVGShapes shapes) {
		
		super(input, isLTR, x, y, width, height);
		
		this.palettes = palettes;
		this.shapes = shapes;
		cumulative = true;
		indepAxisPosition = POSITION_SOUTH;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.GraphAreaXY#getPlotArea(double, double, double, double)
	 */
	protected PlotArea getPlotArea(double x, double y, double width, double height) {
		PlotAreaStackArea plotarea = new PlotAreaStackArea(input, isLTR, x, y, width, height, palettes, shapes, useCategories, nls);
		plotarea.setPrimaryDataSets(primaryDataSets);
//		plotarea.setSecondaryDataSets(secondaryDataSets);
		plotarea.setPrimaryDepAxis(primaryDepAxis);
//		plotarea.setSecondaryDepAxis(secondaryDepAxis);
		plotarea.setIndepAxis(indepAxis);
		return plotarea;
	}

}
