/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphAreaStackBar3D.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphAreaStackBar3D.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;


/**
 * <code>GraphAreaStackBar3D</code> class constructs a typical stack bar graph in 3-D space.  The grid
 * lines, and data points within the plot area are displayed in a 3-D perspective.
 */
public class GraphAreaStackBar3D extends GraphAreaXY3D {
    protected static double x3Doffset = 5;
    protected static double y3Doffset = 5;
    static final long serialVersionUID = 1253236315114283177L;

    /**
     * @param input
     * @param x
     * @param y
     * @param width
     * @param height
     */
    public GraphAreaStackBar3D(Chart input, boolean isLTR, double x, double y,
        double width, double height, SVGColorPalettes palettes, String POSITION) {
        super(input, isLTR, x, y, width, height, x3Doffset, y3Doffset);
        this.palettes = palettes;
        indepAxisPosition = POSITION;
        cumulative = true;
    }

    /* (non-Javadoc)
     * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartXYGraphArea#getPlotArea()
     */
    protected PlotArea getPlotArea(double x, double y, double width,
        double height) {
        PlotAreaStackBar plotarea = new PlotAreaStackBar3D(input, isLTR, x,
                y - y3Doffset, width + x3Doffset, height + y3Doffset, palettes,
                useCategories, x3Doffset, y3Doffset, nls);

        if (useCategories) {
            plotarea.setPrimaryDataSets(primaryDataSets);
            plotarea.setPrimaryDepAxis(primaryDepAxis);
            plotarea.setIndepAxis((AxisCategory) indepAxis);
        }

        return plotarea;
    }
}
