/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphAreaXY.java,v 1.1 2005/03/30 08:26:41 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphAreaXY.java,v 1.1 2005/03/30 08:26:41 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.List;
import java.util.Vector;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Axes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSetAssociations;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DependentAxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;


/**
 * 
 */
public abstract class GraphAreaXY extends GraphArea {

	protected boolean useCategories;
	protected boolean useSecondaryAxis = false;
	protected String indepAxisPosition = POSITION_SOUTH;
	protected List datasetList = null;
	protected List primaryDataSets = null;
	protected List secondaryDataSets = null;
	protected AxisNumber primaryDepAxis = null;
	protected AxisNumber secondaryDepAxis = null;
	protected Axis indepAxis = null; 
	protected boolean cumulative = false;
	protected AxisDefinition indepAxisDef = null;
	protected AxisDefinition primaryDepAxisDef = null;
	protected DependentAxisDefinition secondaryDepAxisDef = null;

	/**
	 * Text direction: true if LTR, false if RTL
	 */
	protected boolean isLTR = true;


	/**
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 */
	public GraphAreaXY(Chart input, boolean isLTR, double x, double y, double width, double height) {
		super(input, x, y, width, height);

		// children classes should set the following values:		
		// indepAxisPosition
		// cumulative (ture/false)
		
		this.isLTR = isLTR;
		
		analyzeData();
	}
	
	/**
	 * Find out if secondary axis is used. 
	 * Associate data sets with dependent axes
	 */
	private void analyzeData() {
		DataSetAssociations assoc = null;
		String chartType = input.getType();
		Configuration config = input.getConfiguration();
		if (config != null) {
			Axes axes = config.getAxes();
			if (axes != null) {
				indepAxisDef = axes.getIndependentAxis();
				primaryDepAxisDef = axes.getPrimaryDependentAxis();
				secondaryDepAxisDef = axes.getSecondaryDependentAxis();
				if (secondaryDepAxisDef == null || 
					chartType.equals(VBAR_CHART) ||
					chartType.equals(HBAR_CHART) ||
					chartType.equals(HSTACKBAR_CHART) ||
					chartType.equals(VBAR_CHART3D) ||
					chartType.equals(HBAR_CHART3D) ||
					chartType.equals(HSTACKBAR_CHART3D) ||
					chartType.equals(VSTACKBAR_CHART3D) ||
					chartType.equals(VSTACKBAR_CHART)) {
						
					// bar charts don't use secondary axis
					useSecondaryAxis = false;
				} else {
					assoc = secondaryDepAxisDef.getDataSetAssociations();
					if (assoc == null) {
						useSecondaryAxis = false;
					} else {
						useSecondaryAxis = true;
					}
				}
			}
		}

		Data data = input.getData();
		if (data != null) {
			DataSets datasets = data.getDataSets();
			if (data.getCategories() != null) {
				useCategories = true;
			} else {
				useCategories = false;
			}
			if (datasets != null) {
				datasetList = datasets.getDataSet();
				primaryDataSets = new Vector(datasetList);
				if (datasetList.isEmpty() == false) {
					DataSet dataset = (DataSet) datasetList.get(0);
				}
			}
		}
		if (useSecondaryAxis) {
			if (assoc != null) {
				secondaryDataSets = assoc.getDataSetIds();
				primaryDataSets.removeAll(secondaryDataSets);
			} 
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		SVGBase[] parts = new SVGBase[8]; // 3 axes, grid area, 2 plot area, markerLines, markerRegions
		// Allocate 2 parts for plot area. One of them is below the axis, and the other
		// is above the axis. Use the one below the axis for bar charts, and the one above
		// the axis for line charts.
		setChildren(parts);

		if (indepAxisPosition.equals(POSITION_SOUTH)) {
			// create horizontal category axis
			if (useCategories) {
				indepAxis = new AxisCategoryHorizontal(input, isLTR, nls);
			} else {
				indepAxis = new AxisNumberHorizontal(input, isLTR, datasetList, AXIS_TYPE_INDEPENDENT_AXIS, cumulative, nls);
			}

			// create vertical dependent axis (number axis)
			primaryDepAxis = new AxisNumberVertical(input, isLTR, primaryDataSets, AXIS_TYPE_PRIMARY_DEPENDENT_AXIS, cumulative, nls);
			double marginHeight = primaryDepAxis.getMarginForMax();

			if (useSecondaryAxis == true) {
				// create vertical 2nd dependent axis (number axis)
				secondaryDepAxis = new AxisNumberVertical(input, isLTR, secondaryDataSets, AXIS_TYPE_SECONDARY_DEPENDENT_AXIS, cumulative, nls);
				if (marginHeight < secondaryDepAxis.getMarginForMax())
					marginHeight = secondaryDepAxis.getMarginForMax();
			}
			

			boolean primaryDepAxisOnLeft = isLTR ? true : false;
			double graphAreaWidth = (new Double(getWidth())).doubleValue();
			double graphAreaHeight = (new Double(getHeight())).doubleValue();
			double leftVertAxisWidth;
			double rightVertAxisWidth;
			int margin = 0;
			if (indepAxis instanceof AxisNumber) {
				margin = ((AxisNumber) indepAxis).getMarginForMax();
			}
			if (primaryDepAxisOnLeft) {
				leftVertAxisWidth = primaryDepAxis==null ? 0 : primaryDepAxis.getAxisWidth();
				rightVertAxisWidth = secondaryDepAxis==null ? margin : secondaryDepAxis.getAxisWidth();
			} else {
				leftVertAxisWidth = secondaryDepAxis==null ? margin : secondaryDepAxis.getAxisWidth();
				rightVertAxisWidth = primaryDepAxis==null ? 0 : primaryDepAxis.getAxisWidth();
			}
			double horAxisHeight = indepAxis.getAxisHeight();
			double indepAxisLength = graphAreaWidth - leftVertAxisWidth - rightVertAxisWidth - GRAPH_AREA_MARGIN * 2;
			double depAxisLength = graphAreaHeight - horAxisHeight - GRAPH_AREA_TOP_MARGIN - marginHeight - GRAPH_AREA_MARGIN;
			
			// If the chart is too small, it is possible for indepAxisLength and depAxisLength to become negative.
			// In that case, simply set axis length to 0.  The chart won't be readable anyways.
			// The height attribute of svg cannot be a negative value.
			if (indepAxisLength <= 0) {
				indepAxisLength = 1;
			}
			if (depAxisLength <= 0) {
				depAxisLength = 1;
			}
			
			indepAxis.setAxisLength(indepAxisLength);
			indepAxis.setCrossPoint(leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_TOP_MARGIN + depAxisLength+marginHeight);
			parts[3] = indepAxis;
			
			primaryDepAxis.setAxisLength(depAxisLength);
			if (primaryDepAxisOnLeft) {
				primaryDepAxis.setCrossPoint(leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_TOP_MARGIN + depAxisLength+marginHeight);
			} else {
				primaryDepAxis.setCrossPoint(graphAreaWidth - rightVertAxisWidth - GRAPH_AREA_MARGIN, 
					GRAPH_AREA_TOP_MARGIN + depAxisLength+marginHeight);
			}
			parts[4] = primaryDepAxis;
			
			if (secondaryDepAxis != null) {
				secondaryDepAxis.setAxisLength(depAxisLength);
				if (primaryDepAxisOnLeft) {
					secondaryDepAxis.setCrossPoint(graphAreaWidth - rightVertAxisWidth - GRAPH_AREA_MARGIN, 
						GRAPH_AREA_TOP_MARGIN + depAxisLength+marginHeight);
				} else {
					secondaryDepAxis.setCrossPoint(leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_TOP_MARGIN + depAxisLength+marginHeight);
				}
				parts[5] = secondaryDepAxis;
			}
			
			// create grids, draw the grid first 
			Grid grid = new Grid(input, isLTR, leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_TOP_MARGIN+marginHeight, indepAxisLength, depAxisLength);
			grid.setPrimaryDepAxis(primaryDepAxis);
			grid.setSecondaryDepAxis(secondaryDepAxis);
			grid.setIndepAxis(indepAxis);
			parts[0] = grid;  // draw grid before axes
			
			// create the plot area
			// plot area is chart type specific
			// ask the subclass to return an instance of plot area
			SVGBase plotarea = getPlotArea(leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_TOP_MARGIN+marginHeight, indepAxisLength, depAxisLength);
			if (input.getType().equals(VBAR_CHART) || 
				input.getType().equals(HBAR_CHART) || 
				input.getType().equals(HSTACKBAR_CHART) || 
				input.getType().equals(VSTACKBAR_CHART)) {
				parts[2] = plotarea;
			} else {
				parts[6] = plotarea;
			}

			// create marker lines			
			MarkerLines markerLines = new MarkerLines(input, isLTR, leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_TOP_MARGIN+marginHeight, indepAxisLength, depAxisLength, indepAxisPosition, nls);
			markerLines.setIndepAxis(indepAxis);
			markerLines.setIndepAxisDef(indepAxisDef);
			markerLines.setPrimaryDepAxis(primaryDepAxis);
			markerLines.setPrimaryDepAxisDef(primaryDepAxisDef);
			markerLines.setSecondaryDepAxis(secondaryDepAxis);
			markerLines.setSecondaryDepAxisDef(secondaryDepAxisDef);
			parts[7] = markerLines;
			
			// create marker regions			
			MarkerRegions markerRegions = new MarkerRegions(input, isLTR, leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_TOP_MARGIN+marginHeight, indepAxisLength, depAxisLength, indepAxisPosition, nls);
			markerRegions.setIndepAxis(indepAxis);
			markerRegions.setIndepAxisDef(indepAxisDef);
			markerRegions.setPrimaryDepAxis(primaryDepAxis);
			markerRegions.setPrimaryDepAxisDef(primaryDepAxisDef);
			markerRegions.setSecondaryDepAxis(secondaryDepAxis);
			markerRegions.setSecondaryDepAxisDef(secondaryDepAxisDef);
			parts[1] = markerRegions;
			
		} else if (indepAxisPosition.equals(POSITION_WEST)) {
			// Independent axis that appear on the left (horizontal bar charts)
			// must be a category axis.  However, if categories are not defined
			// in a bar chart (empty charts), useCategories will then be false.
			// In that case, we will create an empty category axis.
			
			// create vertical category axis
			indepAxis = new AxisCategoryVertical(input, isLTR, nls);
   
			// create horizontal primary dependent axis (bottom)
			primaryDepAxis = new AxisNumberHorizontal(input, isLTR, primaryDataSets, AXIS_TYPE_PRIMARY_DEPENDENT_AXIS, cumulative, nls);
			double marginHeight = indepAxis.getMarginForMax();
   
			if (useSecondaryAxis == true) {
				// create vertical 2nd dependent axis (number axis) (top)
				secondaryDepAxis = new AxisNumberHorizontal(input, isLTR, secondaryDataSets, AXIS_TYPE_SECONDARY_DEPENDENT_AXIS, cumulative, nls);
			}
   
   			boolean indepAxisOnLeft = isLTR ? true : false;
			double graphAreaWidth = (new Double(getWidth())).doubleValue();
			double graphAreaHeight = (new Double(getHeight())).doubleValue();
			double bottomAxisHeight = primaryDepAxis==null ? 0 : primaryDepAxis.getAxisHeight();
			double topAxisHeight = secondaryDepAxis==null ? 0 : secondaryDepAxis.getAxisHeight();
			double leftVertAxisWidth;
			double rightVertAxisWidth;

			int margin = 0;
			if (primaryDepAxis instanceof AxisNumber) {
				margin = ((AxisNumber) primaryDepAxis).getMarginForMax();
			}
			if (indepAxisOnLeft) {
				leftVertAxisWidth = indepAxis.getAxisWidth();
				rightVertAxisWidth = margin;
			} else {
				leftVertAxisWidth = margin;
				rightVertAxisWidth = indepAxis.getAxisWidth();
			}
			double indepAxisLength = graphAreaHeight - bottomAxisHeight - topAxisHeight - marginHeight - GRAPH_AREA_MARGIN * 2;
			double depAxisLength = graphAreaWidth - leftVertAxisWidth - rightVertAxisWidth - GRAPH_AREA_MARGIN * 2;
   
			// If the chart is too small, it is possible for indepAxisLength and depAxisLength to become negative.
			// In that case, simply set axis length to 0.  The chart won't be readable anyways.
			// The height attribute of svg cannot be a negative value.
			if (indepAxisLength <= 0) {
				indepAxisLength = 1;
			}
			if (depAxisLength <= 0) {
				depAxisLength = 1;
			}
			
			indepAxis.setAxisLength(indepAxisLength);
			if (indepAxisOnLeft) {
				indepAxis.setCrossPoint(leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_MARGIN + indepAxisLength + marginHeight + topAxisHeight);
			} else {
				indepAxis.setCrossPoint(graphAreaWidth - rightVertAxisWidth - GRAPH_AREA_MARGIN, GRAPH_AREA_MARGIN + indepAxisLength + marginHeight + topAxisHeight);
			}
			parts[3] = indepAxis;
   
			primaryDepAxis.setAxisLength(depAxisLength);
			primaryDepAxis.setCrossPoint(leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_MARGIN + indepAxisLength + marginHeight  + topAxisHeight);
			parts[4] = primaryDepAxis;
   
			if (secondaryDepAxis != null) {
				secondaryDepAxis.setAxisLength(depAxisLength);
				secondaryDepAxis.setCrossPoint(leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_MARGIN + topAxisHeight);
				parts[5] = secondaryDepAxis;
			}
   
			// create grids, draw the grid first 
			Grid grid = new Grid(input, isLTR, leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_MARGIN + topAxisHeight+marginHeight, depAxisLength, indepAxisLength );
			grid.setPrimaryDepAxis(primaryDepAxis);
			grid.setSecondaryDepAxis(secondaryDepAxis);
			grid.setIndepAxis(indepAxis);
			parts[0] = grid;  // draw grid before axes
   
			// create the plot area
			// plot area is chart type specific
			// ask the subclass to return an instance of plot area
			SVGBase plotarea = getPlotArea(leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_MARGIN + topAxisHeight+marginHeight, depAxisLength, indepAxisLength );
			if (input.getType().equals(VBAR_CHART) || 
				input.getType().equals(HBAR_CHART) || 
				input.getType().equals(HSTACKBAR_CHART) || 
				input.getType().equals(VSTACKBAR_CHART)) {
				parts[2] = plotarea;
			} else {
				parts[6] = plotarea;
			}
  
			// create marker lines			
			MarkerLines markerLines = new MarkerLines(input, isLTR, leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_MARGIN + topAxisHeight+marginHeight, depAxisLength, indepAxisLength, indepAxisPosition, nls);
			markerLines.setIndepAxis(indepAxis);
			markerLines.setIndepAxisDef(indepAxisDef);
			markerLines.setPrimaryDepAxis(primaryDepAxis);
			markerLines.setPrimaryDepAxisDef(primaryDepAxisDef);
			markerLines.setSecondaryDepAxis(secondaryDepAxis);
			markerLines.setSecondaryDepAxisDef(secondaryDepAxisDef); 
			parts[7] = markerLines;

			// create marker regions			
			MarkerRegions markerRegions = new MarkerRegions(input, isLTR, leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_TOP_MARGIN+marginHeight, indepAxisLength, depAxisLength, indepAxisPosition, nls);
			markerRegions.setIndepAxis(indepAxis);
			markerRegions.setIndepAxisDef(indepAxisDef);
			markerRegions.setPrimaryDepAxis(primaryDepAxis);
			markerRegions.setPrimaryDepAxisDef(primaryDepAxisDef);
			markerRegions.setSecondaryDepAxis(secondaryDepAxis);
			markerRegions.setSecondaryDepAxisDef(secondaryDepAxisDef);
			parts[1] = markerRegions;
			
		} else {
			// invalid axis location
			Utilities.assertion(false);
		}
	}
	
	protected abstract PlotArea getPlotArea(double x, double y, double width, double height);
	
}
