/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphAreaXY3D.java,v 1.1 2005/03/30 08:26:41 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphAreaXY3D.java,v 1.1 2005/03/30 08:26:41 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;


/**
 * <code>GraphAreaXY3D</code> class constructs a typical graph in 3-D space.  The grid
 * lines, and data points within the plot area are displayed in a 3-D perspective.
 */
abstract public class GraphAreaXY3D  extends GraphAreaXY {

	protected double x3Doffset;
	protected double y3Doffset; 
		


	/**
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 */
	public GraphAreaXY3D(Chart input, boolean isLTR, double x, double y, double width, double height, double x3Doffset, double y3Doffset) {
		super(input, isLTR, x, y, width, height);
		this.y3Doffset = y3Doffset;
		this.x3Doffset = x3Doffset;		
	}
	

	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		SVGBase[] parts = new SVGBase[7]; // 3 axes, grid area, 2 plot area, markerLines
		// Allocate 2 parts for plot area. One of them is below the axis, and the other
		// is above the axis. Use the one below the axis for bar charts, and the one above
		// the axis for line charts.
		setChildren(parts);

		if (indepAxisPosition.equals(POSITION_SOUTH)) {
			// create horizontal category axis
			if (useCategories) {
				indepAxis = new AxisCategoryHorizontal3D(input, isLTR, x3Doffset, y3Doffset, nls);
			} else {
				indepAxis = new AxisNumberHorizontal3D(input, isLTR, datasetList, AXIS_TYPE_INDEPENDENT_AXIS, cumulative, x3Doffset, y3Doffset, nls);
			}

			// create vertical dependent axis (number axis)
			primaryDepAxis = new AxisNumberVertical3D(input, isLTR, primaryDataSets, AXIS_TYPE_PRIMARY_DEPENDENT_AXIS, cumulative, x3Doffset, y3Doffset, nls);
			double marginHeight = primaryDepAxis.getMarginForMax();

			if (useSecondaryAxis == true) {
				// create vertical 2nd dependent axis (number axis)
				secondaryDepAxis = new AxisNumberVertical3D(input, isLTR, secondaryDataSets, AXIS_TYPE_SECONDARY_DEPENDENT_AXIS, cumulative, x3Doffset, y3Doffset, nls);
				if (marginHeight < secondaryDepAxis.getMarginForMax())
					marginHeight = secondaryDepAxis.getMarginForMax();
			}

			boolean primaryDepAxisOnLeft = isLTR ? true : false;
			double graphAreaWidth = (new Double(getWidth())).doubleValue();
			double graphAreaHeight = (new Double(getHeight())).doubleValue();
			double leftVertAxisWidth;
			double rightVertAxisWidth;
			int margin = 0;
			if (indepAxis instanceof AxisNumber) {
				margin = ((AxisNumber) indepAxis).getMarginForMax();
			}
			if (primaryDepAxisOnLeft) {
				leftVertAxisWidth = primaryDepAxis==null ? 0 : primaryDepAxis.getAxisWidth();
				rightVertAxisWidth = secondaryDepAxis==null ? margin : secondaryDepAxis.getAxisWidth();
			} else {
				leftVertAxisWidth = secondaryDepAxis==null ? margin : secondaryDepAxis.getAxisWidth();
				rightVertAxisWidth = primaryDepAxis==null ? 0 : primaryDepAxis.getAxisWidth();
			}
			double horAxisHeight = indepAxis.getAxisHeight();
			double indepAxisLength = graphAreaWidth - leftVertAxisWidth - rightVertAxisWidth - GRAPH_AREA_MARGIN * 2;
			double depAxisLength = graphAreaHeight - horAxisHeight - GRAPH_AREA_TOP_MARGIN - GRAPH_AREA_MARGIN-marginHeight;
			
			indepAxis.setAxisLength(indepAxisLength);
			indepAxis.setCrossPoint(leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_TOP_MARGIN + depAxisLength+y3Doffset+marginHeight);
			parts[1] = indepAxis;
			
			primaryDepAxis.setAxisLength(depAxisLength);
			if (primaryDepAxisOnLeft) {
				primaryDepAxis.setCrossPoint(leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_TOP_MARGIN + depAxisLength+y3Doffset+marginHeight);
			} else {
				primaryDepAxis.setCrossPoint(graphAreaWidth - rightVertAxisWidth - GRAPH_AREA_MARGIN, 
					GRAPH_AREA_TOP_MARGIN + depAxisLength+y3Doffset+marginHeight);
			}
			parts[2] = primaryDepAxis;
			
			if (secondaryDepAxis != null) {
				secondaryDepAxis.setAxisLength(depAxisLength);
				if (primaryDepAxisOnLeft) {
					secondaryDepAxis.setCrossPoint(graphAreaWidth - rightVertAxisWidth - GRAPH_AREA_MARGIN, 
						GRAPH_AREA_TOP_MARGIN + depAxisLength+y3Doffset+marginHeight);
				} else {
					secondaryDepAxis.setCrossPoint(leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_TOP_MARGIN + depAxisLength+y3Doffset+marginHeight);
				}
				parts[3] = secondaryDepAxis;
			}
			
			// create grids, draw the grid first 
			Grid3D grid = new Grid3D(input, isLTR, leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_TOP_MARGIN+marginHeight, indepAxisLength+Math.abs(x3Doffset), depAxisLength+Math.abs(y3Doffset), x3Doffset, y3Doffset);
			grid.setPrimaryDepAxis(primaryDepAxis);
			grid.setSecondaryDepAxis(secondaryDepAxis);
			grid.setIndepAxis(indepAxis);
			parts[0] = grid;  // draw grid before axes
			
			// create the plot area
			// plot area is chart type specific
			// ask the subclass to return an instance of plot area
			SVGBase plotarea = getPlotArea(leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_TOP_MARGIN+y3Doffset+marginHeight, indepAxisLength, depAxisLength);
			parts[4] = plotarea;

			// create marker lines			
			MarkerLines markerLines = new MarkerLines(input, isLTR, leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_TOP_MARGIN+y3Doffset+marginHeight, indepAxisLength, depAxisLength, indepAxisPosition, nls);
			markerLines.setIndepAxis(indepAxis);
			markerLines.setIndepAxisDef(indepAxisDef);
			markerLines.setPrimaryDepAxis(primaryDepAxis);
			markerLines.setPrimaryDepAxisDef(primaryDepAxisDef);
			markerLines.setSecondaryDepAxis(secondaryDepAxis);
			markerLines.setSecondaryDepAxisDef(secondaryDepAxisDef);
			parts[6] = markerLines;
			
		} else if (indepAxisPosition.equals(POSITION_WEST)) {
			// Independent axis that appear on the left (horizontal bar charts)
			// must be a category axis.  However, if categories are not defined
			// in a bar chart (empty charts), useCategories will then be false.
			// In that case, we will create an empty category axis.
			
			// create vertical category axis
			indepAxis = new AxisCategoryVertical3D(input, isLTR, x3Doffset, y3Doffset, nls);
			double marginHeight = indepAxis.getMarginForMax();
   
			// create horizontal primary dependent axis (bottom)
			primaryDepAxis = new AxisNumberHorizontal3D(input, isLTR, primaryDataSets, AXIS_TYPE_PRIMARY_DEPENDENT_AXIS, cumulative, x3Doffset, y3Doffset, nls);
   
			if (useSecondaryAxis == true) {
				// create vertical 2nd dependent axis (number axis) (top)
				secondaryDepAxis = new AxisNumberHorizontal3D(input, isLTR, secondaryDataSets, AXIS_TYPE_SECONDARY_DEPENDENT_AXIS, cumulative, x3Doffset, y3Doffset, nls);
			}
   
   			boolean indepAxisOnLeft = isLTR ? true : false;
			double graphAreaWidth = (new Double(getWidth())).doubleValue();
			double graphAreaHeight = (new Double(getHeight())).doubleValue();
			double bottomAxisHeight = primaryDepAxis==null ? 0 : primaryDepAxis.getAxisHeight();
			double topAxisHeight = secondaryDepAxis==null ? 0 : secondaryDepAxis.getAxisHeight();
			double leftVertAxisWidth;
			double rightVertAxisWidth;

			int margin = 0;
			if (primaryDepAxis instanceof AxisNumber) {
				margin = ((AxisNumber) primaryDepAxis).getMarginForMax();
			}
			if (indepAxisOnLeft) {
				leftVertAxisWidth = indepAxis.getAxisWidth();
				rightVertAxisWidth = margin;
			} else {
				leftVertAxisWidth = margin;
				rightVertAxisWidth = indepAxis.getAxisWidth();
			}
			double indepAxisLength = graphAreaHeight - bottomAxisHeight - topAxisHeight - GRAPH_AREA_MARGIN * 2 -marginHeight;
			double depAxisLength = graphAreaWidth - leftVertAxisWidth - rightVertAxisWidth - GRAPH_AREA_MARGIN * 2;
   
			indepAxis.setAxisLength(indepAxisLength);
			if (indepAxisOnLeft) {
				indepAxis.setCrossPoint(leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_MARGIN + indepAxisLength+marginHeight + topAxisHeight+y3Doffset);
			} else {
				indepAxis.setCrossPoint(graphAreaWidth - rightVertAxisWidth - GRAPH_AREA_MARGIN, GRAPH_AREA_MARGIN + indepAxisLength+marginHeight + topAxisHeight+y3Doffset);
			}
			parts[2] = indepAxis;
   
			primaryDepAxis.setAxisLength(depAxisLength);
			primaryDepAxis.setCrossPoint(leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_MARGIN + indepAxisLength+marginHeight + topAxisHeight+y3Doffset);
			parts[3] = primaryDepAxis;
   
			if (secondaryDepAxis != null) {
				secondaryDepAxis.setAxisLength(depAxisLength);
				secondaryDepAxis.setCrossPoint(leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_MARGIN + topAxisHeight+marginHeight);
				parts[4] = secondaryDepAxis;
			}
   
			// create grids, draw the grid first 
			Grid3D grid = new Grid3D(input, isLTR, leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_MARGIN+marginHeight + topAxisHeight, depAxisLength+Math.abs(x3Doffset), indepAxisLength+Math.abs(y3Doffset), x3Doffset, y3Doffset);
			grid.setPrimaryDepAxis(primaryDepAxis);
			grid.setSecondaryDepAxis(secondaryDepAxis);
			grid.setIndepAxis(indepAxis);
			parts[0] = grid;  // draw grid before axes
   
			// create the plot area
			// plot area is chart type specific
			// ask the subclass to return an instance of plot area
			SVGBase plotarea = getPlotArea(leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_MARGIN + topAxisHeight+marginHeight+y3Doffset, depAxisLength, indepAxisLength);
			parts[5] = plotarea;
  
			// create marker lines			
			MarkerLines markerLines = new MarkerLines(input, isLTR, leftVertAxisWidth + GRAPH_AREA_MARGIN, GRAPH_AREA_MARGIN + topAxisHeight+marginHeight+y3Doffset, depAxisLength, indepAxisLength, indepAxisPosition, nls);
			markerLines.setIndepAxis(indepAxis);
			markerLines.setIndepAxisDef(indepAxisDef);
			markerLines.setPrimaryDepAxis(primaryDepAxis);
			markerLines.setPrimaryDepAxisDef(primaryDepAxisDef);
			markerLines.setSecondaryDepAxis(secondaryDepAxis);
			markerLines.setSecondaryDepAxisDef(secondaryDepAxisDef); 
			parts[6] = markerLines;

		} else {
			// invalid axis location
			Utilities.assertion(false);
		}
	}
	
}
