/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IConstants.java,v 1.1 2005/03/30 08:26:40 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IConstants.java,v 1.1 2005/03/30 08:26:40 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


/**
 * 
 * $Revision: 1.1 $
 */
public interface IConstants {
	/**
	 * Position - East 
	 */
	public static final String POSITION_EAST = "E";

	/**
	 * Position - South
	 */
	public static final String POSITION_SOUTH = "S";

	/**
	 * Position - West
	 */
	public static final String POSITION_WEST = "W";

	/**
	 * Position - North
	 */
	public static final String POSITION_NORTH = "N"; 
	
	/**
	 * Postion - leading
	 */
	public static final String POSITION_LEADING = "LEADING";
	
	/**
	 * Position - trailing
	 */
	public static final String POSITION_TRAILING = "TRAILING";
	
	/**
	 * Orientation - Horizontal
	 */
	public static final short HORIZONTAL = 0;

	/**
	 * Orientation - Vertical
	 */
	public static final short VERTICAL = 1;
	
	/////////////////////////////////
	// Font size related constants
	/////////////////////////////////

	/**
	 * Base font size
	 */
	public static final int BASE_FONT_SIZE = 8;
	
	//////////////////////////
	// Chart area constants
	//////////////////////////

	/**
	 * default chart width (for all charts except meter chart)
	 */
	public static final double CHART_AREA_DEFAULT_WIDTH = 450;
	
	/**
	 * default chart height
	 */
	public static final double CHART_AREA_DEFAULT_HEIGHT = 320;
	
	/**
	 * default width for meter charts
	 */
	public static final double CHART_AREA_METER_DEFAULT_WIDTH = 325;		
	

	//////////////////////////
	// Axis constants
	//////////////////////////

	/**
	 * Constant - independent axis
	 */
	public static final short AXIS_TYPE_INDEPENDENT_AXIS = 0;
	
	/**
	 * Constant - primary dependent axis
	 */
	public static final short AXIS_TYPE_PRIMARY_DEPENDENT_AXIS = 1;
	
	/**
	 * Constant - secondary dependent axis
	 */
	public static final short AXIS_TYPE_SECONDARY_DEPENDENT_AXIS = 2;

	/**
	 * Length of tick mark
	 */
	public static int TICK_MARK_LENGTH = 5;
	
	/**
	 * Axis label font size
	 */
	public static final int AXIS_LABEL_FONT_SIZE = BASE_FONT_SIZE;
	
	/**
	 * Axis title font size
	 */
	public static final int AXIS_TITLE_FONT_SIZE = BASE_FONT_SIZE+1;
	
	/**
	 * Space between axis and label
	 */
	public static final int AXIS_SPACE_BTW_AXIS_AND_LABEL = 8;
	
	/**
	 * Space between labels and title (used in horizontal number axes)
	 */
	public static final int AXIS_SPACE_BTW_TITLE_AND_LABEL = 5;
	

	//////////////////////////
	// Graph area constants
	//////////////////////////
	
	/**
	 * Margin for graph area (used on left, right and bottom sides)
	 */
	public static final double GRAPH_AREA_MARGIN = 10;

	/**
	 * Top margin in Graph area
	 * (need more space at the top)
	 */
	public static final double GRAPH_AREA_TOP_MARGIN = 20;
	
	//////////////////////////
	// Plot area constants
	//////////////////////////
	
	public static final double PLOT_AREA_MARGIN = 5;

	//////////////////////////
	// TIMESTAMP constants
	//////////////////////////
	
	/**
	 * Side margin for timestamp part
	 */
	public static final double TIMESTAMP_SIDE_MARGIN = 10;

	/**
	 * bottom margin for timestamp
	 */
	public static final double TIMESTAMP_BOTTOM_MARGIN = 10;
		
	/**
	 * height of the timestamp part
	 */
	public static final double TIMESTAMP_HEIGHT = 20;
	
	//////////////////////////
	// Marker Line constants
	//////////////////////////
	public static final String MARKER_LINE_DEFAULT_COLOR = "red";

	//////////////////////////
	// Legend constants
	//////////////////////////
	/**
	 * side margin of legend, used if margin is next to the graph area
	 */
	public static final double LEGEND_NARROW_SIDE_MARGIN = 5;
	
	/**
	 * side margin of legend, used at the edge of the chart area
	 */
	public static final double LEGEND_WIDE_SIDE_MARGIN = 10;
	
	/**
	 * side margin for horizontal legends
	 */
	public static final int LEGEND_HORIZONTAL_SIDE_MARGIN = 30;

	/**
	 * top margin for vertical legends
	 */
	public static final double LEGEND_VERTICAL_TOP_MARGIN = 20;
	
	/**
	 * top margin for horizontal legends
	 */
	public static final double LEGEND_HORIZONTAL_TOP_MARGIN = 10;
	
	/**
	 * space after legend title and before the first legend item
	 */
	public static final double LEGEND_SPACE_AFTER_TITLE = 15;
	
	/**
	 * space between legend items
	 */
	public static final double LEGEND_SPACE_BETWEEN_ITEMS = 10;
	
	/**
	 * space between legend symbol and legend text
	 */
	public static final double LEGEND_SPACE_BETWEEN_SYMBOL_AND_TEXT = 5;
	
	/**
	 * font size of legend title
	 */
	public static final int LEGEND_TITLE_FONT_SIZE = BASE_FONT_SIZE+2;
	
	/**
	 * font size of legend item text
	 */
	public static final int LEGEND_ITEM_FONT_SIZE = BASE_FONT_SIZE;

	/**
	 * height of the legend if it is positioned at the top of bottom of the graph
	 */
	public static final int LEGEND_HORIZONTAL_HEIGHT = 36;
	
	/**
	 * The length of the line drawn through the symbol in the legend area.
	 */
	public static final int LEGEND_SYMBOL_LINE_LENGTH = 16;

	/**
	 * Number of items per row (for horizontal legends only)
	 */
	public static final int LEGEND_ITEMS_PER_ROW = 8;
	
	/**
	 * For horizontal legends: The legend height can be at most this fraction of the height of the chart.
	 * For example, if the chart height is 500, the height of the horizontal legend can be at most 250.
	 */
	public static final double LEGEND_MAX_HEIGHT_FRACTION = 0.5;
	
	/**
	 * For vertical legends: The legend width can be at most this fraction of the width of the chart.
	 * For example, if the chart width is 500, the width of the vertical legend can be at most 250.
	 */
	public static final double LEGEND_MAX_WIDTH_FRACTION = 0.5;
	
	//////////////////////////
	// Title Bar
	//////////////////////////

	public static final double TITLE_HEIGHT = 36;
	public static final double TITLE_SIDE_MARGIN = 10;
	public static final int TITLE_FONT_SIZE = BASE_FONT_SIZE+3;
	public static final double TITLE_PREF_ICON_WIDTH = 30;
	public static final double TITLE_PREF_ICON_HEIGHT = 24;

	//////////////////////////
	// Miscellaneous
	//////////////////////////

	/**
	 * radius of the "hole" shape
	 */
	public static final double HOLE_RADIUS = 2.8;
	
	/**
	 * EMPTY_STRING
	 */
	String EMPTY_STRING = "";
	
	/**
	 * Visibililty value.  Element is visible.
	 */
	public static final String VISIBLE = "visible";
	/**
	 * Visibililty value.  Element is hidden.
	 */
	public static final String HIDDEN = "hidden"; 


	/**
	 * Text anchor value.  Anchor the text from the starting point.
	 */
	public static final int TEXT_ANCHOR_START = 0;
	
	/**
	 * Text anchor value.  Anchor the text from the middle point.
	 */
	public static final int TEXT_ANCHOR_MIDDLE = 1;

	/**
	 * Text anchor value.  Anchor the text from the end point.
	 */
	public static final int TEXT_ANCHOR_END = 2;

}
