/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IGraphicDocumentStyle.java,v 1.1 2005/03/30 08:26:41 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IGraphicDocumentStyle.java,v 1.1 2005/03/30 08:26:41 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

 
import org.eclipse.tptp.platform.report.chart.svg.internal.part.IConstants;

/**
 * <code>IGraphicDocumentStyle</code> interface defines the default CSS style classes, colour
 * palettes, and other basic attributes of the graphic.
 * 
 * $Revision: 1.1 $
 */
public interface IGraphicDocumentStyle {
	/**
	 * CSS default common style id.
	 */
	String DEFAULT_STYLE_ID = "defaultStyleRules";
		
	/**
	 * CSS default common style type.
	 */
	String STYLE_TYPE = "text/css";
		
		
	/**
	 * CSS default common style classes (rules).  
	 */
	String COMMON_STYLE = 
		" .graphTitle {font-weight:bold; font-style:normal; font-size:" + IConstants.TITLE_FONT_SIZE + "pt; fill:#000000; stroke-width:0.75pt;} " +
		".graphTimeStamp {font-weight:normal; font-style:normal; font-size:" + IConstants.BASE_FONT_SIZE + "pt; fill:#000000; fill-opacity:0.6} " +
		".legendTitle {font-weight:normal; font-style:normal; font-size:" + IConstants.LEGEND_TITLE_FONT_SIZE + "pt; fill:#000000; text-anchor:start; fill-opacity:0.6} " +
		".legendData {font-weight:normal; font-style:normal; font-size:" + IConstants.LEGEND_ITEM_FONT_SIZE + "pt; text-anchor:start; fill:#000000;} " +
		".tooltip {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000;}" +
		".anchorAtEnd {text-anchor: end;} " +
		".anchorAtStart {text-anchor: start;} " +
		".anchorAtMiddle {text-anchor: middle;}";
	
	// not used (used to be in COMMON_STYLE)
	//".outline{stroke-width:0.75pt; stroke:#666666; fill:#ffffff;} " +
	//" .keyline{stroke-width:0.75pt; stroke:#666666;} " +
	//" .st1{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} " +
	//".labelsValues {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000;} " +
	//".dataValues {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} " +
	
	
	/**
	 * CSS default meter style classes (rules).  
	 */
	String METER_STYLE =
		" .minmaxRate {font-weight:normal; font-style:normal; font-size:" + IConstants.BASE_FONT_SIZE + "pt; fill:#000000;} " +
		".rateDef {font-weight:normal; font-style:normal; font-size:" + IConstants.BASE_FONT_SIZE + "pt; fill:#000000;fill-opacity:0.5} " +
		".critDiv {font-weight:normal; font-style:normal; font-size:" + IConstants.BASE_FONT_SIZE + "pt; fill:#000000; fill-opacity:0.5} " +
		".graphOutline{fill:none;} " +
		".ticks{fill:none;stroke:#999999;stroke-width:0.75;}  " +
		".speedometerBg{fill:#FFFFFF;} " +
		".innerRim{fill:#999999;} " +
		".outerRim{fill:#006666;} " +
		".needle{stroke:#000000;stroke-width:3;stroke-linecap:round;} " +
		".outerCircle{fill:#000000;stroke:none;} " +
		".innerCircle{fill:#FFFFFF;stroke:none;} " +
		".center{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} " +
		".safeRange{fill:#CCCCCC;stroke:#999999;stroke-width:0.75} " +
		".semiCritical{fill:#FFFF99;stroke:none;} " +
		".critical{fill:#FF0000;stroke:none;} " +
		".actualRate{fill:#CCCCCC;stroke:#999999;} ";	
	
	/**
	 * CSS default pie style classes (rules).  
	 */
	String PIE_STYLE = 
		" .pievalues{stroke:none; font-weight:normal; font-style:normal; font-size:" + IConstants.BASE_FONT_SIZE + "pt; fill:#000000; text-anchor: middle;}" +
		".axisTicks{stroke-width:1pt;stroke:#000000} " +
		".wedgeTick{fill:none;} " +
		".wedgeOutline{fill:none;} " +
		".wedgeColor{fill:#CCCCCC;stroke:none;}";
	
	/**
	 * CSS default XYchart style classes (rules).  
	 */
	String XYCHART_STYLE = 
		" .grid{stroke-width:0.75pt; stroke:#000000;} " +
		".gridline{stroke-width:0.75pt; stroke:#cccccc;} " +
		".griddashline{stroke-width:0.75pt; stroke:#cccccc; stroke-dasharray:2, 2; fill:none;} " +
		".axisLines{stroke-width:1pt;stroke:#000000} " +
		".zero3DAxisLines{stroke-width:0pt;stroke:#808080;fill:#808080} " +
		".axis3DLimitLines{stroke-width:1pt;stroke:#cccccc;fill:#cccccc} " +
		".axis3DLines{stroke-width:1pt;stroke:#000000;fill:#000000} " +
		".axisTicks{stroke-width:1pt;stroke:#000000} " +
		".linestyle{stroke-linecap:round; stroke-width:0.75;} " +
		".linestyle3D{stroke-linecap:round; stroke-width:0;} " +
		".axisTitles{font-weight:normal; font-style:normal; font-size:" + IConstants.AXIS_TITLE_FONT_SIZE + "pt; fill:#000000;} " + 
		".axisLabels{font-weight:normal; font-style:normal; font-size:" + IConstants.AXIS_LABEL_FONT_SIZE + "pt; fill:#000000;} ";
	
	// not used (used to be in XYCHART_STYLE)
//	".solidLine{fill:none;stroke:#CCCCCC;stroke-width:1;} " +
//	".dashLine{fill:none;stroke:#CCCCCC;stroke-width:1;stroke-dasharray:2;} " +
//	".catOutline{fill:none;} " +
//	".catColor{fill:#003399;stroke:none;} " +
//	".exactValuesBox{fill:#FFFFCC;stroke:#999999;stroke-width:1;} " +
//	".xyTitleLabels {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; fill-opacity:0.6}";
	
	
	/**
	 * BASIC_FONT = "Arial, sans-serif"
	 */	
	String BASIC_FONT= 					null;//"Arial, sans-serif";
	
	/**
	 * BASIC_FONTSIZE = 8
	 */	
	int BASIC_FONTSIZE= 				8;
	
	/**
	 * BASIC_FONTSTYLE = "font-weight:normal; font-style:normal; font-family:Arial; fill:#000000;"
	 */	
	String BASIC_FONTSTYLE= 			"font-weight:normal; font-style:normal; font-family:Arial; fill:#000000;";
	
	/**
	 * BASIC_SHOW_SHAPES = "On"
	 */	
	String BASIC_SHOW_SHAPES= 			"1";
	
	/**
	 * BASIC_SHOW_VALUES = "0ff"
	 */	
	String BASIC_SHOW_VALUES= 			"0";
	
	/**
	 * BASIC_SHOW_PERCENTS = "0n"
	 */	
	String BASIC_SHOW_PERCENTS= 		"1";
	
	/**
	 * NUMBER_OF_PREFERENCES = 6
	 */
	int NUMBER_OF_PREFERENCES=		6; 
		
}
