/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IGraphicTypeConstants.java,v 1.1 2005/03/30 08:26:40 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IGraphicTypeConstants.java,v 1.1 2005/03/30 08:26:40 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


/**
 * <code>IGraphicTypeConstants</code> interface defines constants
 * denoting the known generated types. Users should extend this to add
 * their own types if it is necessary to distinguish types.
 *  
 * $Revision: 1.1 $
 */ 
public interface IGraphicTypeConstants {	
	/**
	 * The generated type is a line chart.
	 */
	String LINE_CHART=	  "line";
	
	/**
	 * The generated type is a area chart.
	 */
	String AREA_CHART=	  "area";

	/**
	 * The generated type is a stack area chart.
	 */
	String STACK_AREA_CHART=	  "stackedArea";
		
	/**
	 * The generated type is a scatter plot chart.
	 */
	String SCATTER_CHART=	  "scatter";
	
	/**
	 * The generated type is a pie chart.
	 */
	String PIE_CHART=	  "pie";
	
	/**
	 * The generated type is a pie chart.
	 */
	String PIE_CHART3D=	  "pie3D";
	
	/**
	 * The generated type is a bar (vertical column) chart.
	 */
	String VBAR_CHART=	  "verticalBar";

	/**
	 * The generated type is a bar (horizontal column) chart.
	 */
	
	String HBAR_CHART=	  "horizontalBar";

	/**
	 * The generated type is a 3D bar (vertical column) chart.
	 */
	String VBAR_CHART3D=	  "verticalBar3D";

	/**
	 * The generated type is a 3D bar (horizontal column) chart.
	 */
	
	String HBAR_CHART3D=	  "horizontalBar3D";

	/**
	 * The generated type is a bar (vertical column) chart.
	 */
	
	/**
	 * The generated type is a stacked bar (horizontal column) chart.
	 */
	String HSTACKBAR_CHART= "horizontalStackedBar";

	/**
	 * The generated type is a stacked bar (vertical column) chart.
	 */
	String VSTACKBAR_CHART= "verticalStackedBar";
	
	/**
	 * The generated type is a 3D stacked bar (horizontal column) chart.
	 */
	String HSTACKBAR_CHART3D= "horizontalStackedBar3D";

	/**
	 * The generated type is a 3D stacked bar (vertical column) chart.
	 */
	String VSTACKBAR_CHART3D= "verticalStackedBar3D";
	
	/**
	 * The generated type is a meter.
	 */
	String METER=		  "meter";
}

