/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LegendHorizontalRTL.java,v 1.3 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LegendHorizontalRTL.java,v 1.3 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

 

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.SVGShapeIterator;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;


/**
 * 
 */
public class LegendHorizontalRTL extends Legend {
	static final long serialVersionUID = 7379307583915137487L;
	protected double verticalScalingFactor = 1;
	protected double horizontalScalingFactor = 1;

	class Coordinates {
		public double x;
		public double y;
		public Coordinates(double x, double y) {
			this.x = x;
			this.y = y;
		}
	}
	
	protected Coordinates[] legendItemCoordinates;
	
	/**
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 * @param shapes
	 */
	public LegendHorizontalRTL(
		Chart input,
		double x,
		double y,
		double width,
		double height,
		double chartWidth, 
		double chartHeight,
		int margin,
		SVGColorPalettes palettes,
		SVGShapes shapes, 
		NLString nls) {
		super(input, x, y, width, height, chartWidth, chartHeight, margin, palettes, shapes, nls);
		isLTR = false;
		if (legendLabels != null) {
			legendItemCoordinates = new Coordinates[legendLabels.length];
		} else {
			legendItemCoordinates = new Coordinates[0];
		}
		analyzeData();
	}

	protected void analyzeData() {
		double currentX = chartWidth;
		double currentY = LEGEND_HORIZONTAL_TOP_MARGIN;
		double minX = chartWidth;
		double titleWidth = 0;
		boolean newLine = true;
		double lineHeight = BASE_FONT_SIZE + LEGEND_SPACE_BETWEEN_ITEMS;
		double legendWidth = chartWidth - LEGEND_HORIZONTAL_SIDE_MARGIN * 2;

		// get title width
		if (legendTitle != null) {
			fontHelper.setFontSize(LEGEND_TITLE_FONT_SIZE);
			titleWidth = fontHelper.getStringWidth(nls.getString(legendTitle)) + LEGEND_SPACE_AFTER_TITLE;
			currentX -= titleWidth;			
		}
		
		// set font size for the rest of th legend
		fontHelper.setFontSize(LEGEND_ITEM_FONT_SIZE);

		if (useShapes && legendLabels != null) {
			Utilities.assertion(shapes != null);

			for (int i=0; i<legendLabels.length; i++) {
				double itemWidth = LEGEND_SYMBOL_LINE_LENGTH + 
								   LEGEND_SPACE_BETWEEN_SYMBOL_AND_TEXT + 
								   fontHelper.getStringWidth(nls.getString(legendLabels[i])) + 
								   LEGEND_SPACE_BETWEEN_ITEMS;

				if ((currentX - itemWidth < LEGEND_HORIZONTAL_SIDE_MARGIN * 2) && i != 0) {
					newLine = true;
				}
				// set x, y coordinates for the first item of each line
				if (newLine && i != 0) {
					currentY += lineHeight;
					if (currentX < minX) {
						minX = currentX;
					}
					currentX = chartWidth - titleWidth;
				}
				
				legendItemCoordinates[i] = new Coordinates(currentX, currentY);
				
				currentX -= itemWidth;
				newLine = false;
			}
		} else if (!useShapes && legendLabels != null) {
			for (int i=0; i<legendLabels.length; i++) {
				double itemWidth = LEGEND_ITEM_FONT_SIZE +    // width of the square
								   LEGEND_SPACE_BETWEEN_SYMBOL_AND_TEXT + 
								   fontHelper.getStringWidth(nls.getString(legendLabels[i])) + 
								   LEGEND_SPACE_BETWEEN_ITEMS;

				if ((currentX - itemWidth < LEGEND_HORIZONTAL_SIDE_MARGIN * 2) && i != 0) {
					newLine = true;
				}
				// set x, y coordinates for the first item of each line
				if (newLine && i != 0) {
					currentY += lineHeight;
					if (currentX < minX) {
						minX = currentX;
					}
					currentX = chartWidth - titleWidth;
				}

				legendItemCoordinates[i] = new Coordinates(currentX, currentY);
				
				currentX -= itemWidth;
				newLine = false;
			}
		}
		
		if (currentX < minX) {
			minX = currentX;
		}
		
		double naturalLengendHeight = currentY + BASE_FONT_SIZE + LEGEND_WIDE_SIDE_MARGIN;
		double naturalLegendWidth = chartWidth - minX;
		if (isSetCustomHeight == false) {
			if (naturalLengendHeight < chartHeight * LEGEND_MAX_HEIGHT_FRACTION) {
				height = naturalLengendHeight;
			} else {
				height = chartHeight * LEGEND_MAX_HEIGHT_FRACTION;
				// shrink legend to fit
				verticalScalingFactor = height / naturalLengendHeight;
			}
		} else {
			height = customHeight;
			verticalScalingFactor = height / naturalLengendHeight;
		}
		if (naturalLegendWidth > chartWidth - LEGEND_HORIZONTAL_SIDE_MARGIN * 2) {
			horizontalScalingFactor = (chartWidth - LEGEND_HORIZONTAL_SIDE_MARGIN * 2) / naturalLegendWidth;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		// parts: background + transformGroup
		SVGBase[] subElements = new SVGBase[2];
		setChildren(subElements);
		setIdentifier(legendId);

		//parts: n data sets, 1 title
		SVGGroup legendGroup = new SVGGroup();
		SVGBase[] legendMembers = new SVGBase[numOfDataSets + 1];
		legendGroup.setChildren(legendMembers);
		
		//parts: legendGroup
		SVGGroup translateGroup = new SVGGroup();
		SVGBase[] translateGroupMember = new SVGBase[1];
		translateGroup.setChildren(translateGroupMember);
		
		translateGroupMember[0] = legendGroup;
		subElements[1] = translateGroup;

		// draw title
		if (legendTitle != null) {
			legendMembers[0] = drawTitle(chartWidth, LEGEND_HORIZONTAL_TOP_MARGIN + BASE_FONT_SIZE);
		}

		if (useShapes && legendLabels != null) {
			Utilities.assertion(shapes != null);
			SVGShapeIterator shapeIterator = shapes.getShapeIterator();
			for (int i=0; i<legendLabels.length; i++) {
				legendMembers[i+1] = drawLegendItem(shapeIterator.getNextShapeId(datasetArray[i].getId()), shapeIterator.getShapeWidth(), shapeIterator.getShapeHeight(), legendItemCoordinates[i].x, legendItemCoordinates[i].y, i);
			}

		} else if (!useShapes && legendLabels != null) {
			for (int i=0; i<legendLabels.length; i++) {
				legendMembers[i+1] = drawLegendItem(legendItemCoordinates[i].x, legendItemCoordinates[i].y, i);
			}
		} 

		double xOffset = 0;
		double scalingFactor = 1;
		scalingFactor = horizontalScalingFactor < verticalScalingFactor ? horizontalScalingFactor : verticalScalingFactor;
		if (scalingFactor < 1) {
			legendGroup.setTransformation("scale(" + scalingFactor + ")");
			xOffset = chartWidth * (1-scalingFactor);
		}

		translateGroup.setTransformation("translate(" + (xOffset - LEGEND_HORIZONTAL_SIDE_MARGIN) + ",0)");
		
		setHeight(Double.toString(height));

		if (backgroundColor != null && backgroundColor.equals("") == false) {
			SVGRectangle bkground = new SVGRectangle();
			bkground.setXCoordinate("0");
			bkground.setYCoordinate("0");
			bkground.setWidth(getWidth());
			bkground.setHeight(getHeight());
			bkground.setFill(backgroundColor);
			subElements[0] = bkground;
		}
	}

}
