/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Line3D.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Line3D.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/



import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolygon;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;


/**
 * <code>Line3D</code> class draws lines in 3-D.  The depth of the lines depends on 
 * the values of the x3Doffset and y3Doffset values.  The actually depth of the 
 * line can be calculated by taking the square root of the sum of the x3Doffset squared
 * plus the sum of the y3Doffset.  Thus depth is calculated as follows:
 * <p>
 *    depth = sqrt(x3Doffset^2 + y3Doffset^2) 
 * </p>
 */
public class Line3D extends SVGLine {
	static final long serialVersionUID = -4712262470499704315L;
    private double x3Doffset = 0;
    private double y3Doffset = 0;
    private String topDimensionFilter;
    private String rightDimensionFilter;
    private double xMax = 0;
    private double xMin = 0;
    private double yMax = 0;
    private double zeroYCoord = 0;
    private double zeroXCoord = 0;
    private boolean linear = false;
    private double yMin = 0;
    private boolean isLTR = false;
    private boolean isHorizontal = false;
    private double plotWidth;
    private double plotHieght;
    private boolean isNeg = false;
    private boolean stacked = false;

    /**
     * Creates the Document Object Model (DOM) implementation of the SVG "line" element
     * @param Document the target SVG Document
     * @return Element
     * @throws DOMException
     */
    public Element doImplementation(Document svgDocument)
        throws DOMException {
        SVGGroup lineGroup = new SVGGroup();
        lineGroup.setIdentifier(this.getIdentifier());

        SVGBase[] lineParts = new SVGBase[3]; //axis line, major tick marks, minor tick marks and labels, title
        lineGroup.setChildren(lineParts);

        double width = Double.parseDouble(this.getStrokeWidth());
        double d_x1 = Double.parseDouble(this.getX1());
        double d_x2 = Double.parseDouble(this.getX2());
        double d_y1 = Double.parseDouble(this.getY1()) + y3Doffset;
        double d_y2 = Double.parseDouble(this.getY2()) + y3Doffset;
        double br_x = 0;
        double br_y = 0;
        double tr_x = 0;
        double tr_y = 0;
        double bl_x = 0;
        double bl_y = 0;
        double tl_x = 0;
        double tl_y = 0;

        if (isHorizontal) {
            bl_x = tl_x = d_x1 - (width / 2);
            tr_x = br_x = d_x1 + (width / 2);

            if (d_y1 < d_y2) {
                if (d_y1 < (yMin + y3Doffset)) {
                    d_y1 = yMin + y3Doffset;
                }

                if (d_y2 > yMax) {
                    d_y2 = yMax;
                }

                tr_y = tl_y = d_y1;
                br_y = bl_y = d_y2;
            } else if (d_y1 >= d_y2) {
                if (d_y2 < (yMin + y3Doffset)) {
                    d_y2 = yMin + y3Doffset;
                }

                if ((d_y2 < yMax) && (d_y1 > yMax)) {
                    d_y1 = yMax;
                }

                tr_y = tl_y = d_y2;
                br_y = bl_y = d_y1;
            }

        }
        else {
            tr_y = tl_y = d_y1 - (width / 2);
            bl_y = br_y = d_y1 + (width / 2);

            if (d_x1 <= d_x2) {
                if ((!(d_x2 < xMin)) && (d_x1 < xMin)) {
                    d_x1 = xMin;
                }

                if ((!(d_x1 > xMax)) && (d_x2 > (xMax))) {
                    d_x2 = xMax;
                }

                br_x = tr_x = d_x2;
                tl_x = bl_x = d_x1;
            } else if (d_x1 > d_x2) {
                if ((!(d_x1 <xMin)) &&(d_x2 < xMin)) d_x2 = xMin;
                if ((!(d_x2 > xMax)) && (d_x1 > (xMax))) d_x1 = xMax;
                br_x = tr_x = d_x1;
                tl_x = bl_x = d_x2;
            }

        }

		//can not have negative log value
		if (!linear) isNeg = false;

        SVGPolygon mainPoly = new SVGPolygon();
		mainPoly.setStyleClass(this.getStyleClass());
        mainPoly.setStroke("none");
        String mainPolyStr = "";
            
        if (getFill() != null) { 
        	mainPoly.setFill(getFill());
        }
        lineParts[0] = mainPoly;

		if ((tr_x - tl_x) >= 1){
        if (((isHorizontal) && (!isNeg || zeroYCoord<yMin)) || (!isHorizontal)) {
            SVGPolygon topPoly = new SVGPolygon();
            topPoly.setStroke("none");
            topPoly.setStyleClass(this.getStyleClass());
            topPoly.setFill(getFill());
            
            
            
            //!isLTR will have a border on right
            //zero will have a border no matter what
            if ((isLTR || (!stacked)) && ((!isHorizontal && ((tr_y-y3Doffset+3) > (yMin+y3Doffset))) && ((!isHorizontal) && (((!isLTR)  && (tr_x+x3Doffset >= zeroXCoord) && !isNeg) || ((!isLTR)  && (tr_x+x3Doffset >= this.plotWidth-x3Doffset) && !isNeg) || (isLTR && tr_x+x3Doffset >= zeroXCoord && isNeg))))){
	           	topPoly.setPoints(tr_x + "," + tr_y + " " + tl_x + "," + tl_y +
            	    " " + (tl_x + x3Doffset) + "," + (tl_y - y3Doffset) + " " +
        	        (tr_x) + "," + (tr_y - y3Doffset) + " ");
        	    mainPolyStr += tl_x + "," + tl_y + " " + (tl_x+x3Doffset) + "," + (tl_y-y3Doffset) +
            	    " " + (tr_x) + "," + (tr_y - y3Doffset) + " ";
	        }
            else{
	           	topPoly.setPoints(tr_x + "," + tr_y + " " + tl_x + "," + tl_y +
            	    " " + (tl_x + x3Doffset) + "," + (tl_y - y3Doffset) + " " +
        	        (tr_x + x3Doffset) + "," + (tr_y - y3Doffset) + " ");
        	    mainPolyStr += tl_x + "," + tl_y +
            	    " " + (tl_x + x3Doffset) + "," + (tl_y - y3Doffset) + " " +
        	        (tr_x + x3Doffset) + "," + (tr_y - y3Doffset) + " ";
            }
   	        topPoly.setFilter(topDimensionFilter);
            lineParts[1] = topPoly;
        }
		}

        if (((!isHorizontal) && (!isNeg)) || ((!isHorizontal) && (isNeg) && (!isLTR)) || (isHorizontal) || (!isHorizontal && isNeg && isLTR && (br_x== this.xMax && zeroXCoord > xMax))) {
        	if (!((!isLTR) && (!isNeg) && (!isHorizontal)) || (!isHorizontal && isNeg && isLTR && (br_x== this.xMax && zeroXCoord > xMax))){
	            SVGPolygon rightPoly = new SVGPolygon();
    	        rightPoly.setStroke("none");
        	    rightPoly.setStyleClass(this.getStyleClass());
        	    if (getFill() != null) {
        	    	rightPoly.setFill(getFill());
        	    }
        	
        		if ((isHorizontal && isNeg && ((tr_y-y3Doffset) <= zeroYCoord))){
            	rightPoly.setPoints(br_x + "," + br_y + " " + tr_x + "," + tr_y +
	                " " + (tr_x + x3Doffset) + "," + (tr_y) + " " +
    	            (br_x + x3Doffset) + "," + (br_y - y3Doffset) + " ");
    	            
            	mainPolyStr += (tr_x + x3Doffset) + "," + (tr_y) + " " +
    	            (br_x + x3Doffset) + "," + (br_y - y3Doffset) + " ";    	            
		        }
    	        else{
            	rightPoly.setPoints(br_x + "," + br_y + " " + tr_x + "," + tr_y +
	                " " + (tr_x + x3Doffset) + "," + (tr_y - y3Doffset) + " " +
    	            (br_x + x3Doffset) + "," + (br_y - y3Doffset) + " ");
            	mainPolyStr += (br_x + x3Doffset) + "," + (br_y - y3Doffset) + " ";
            }    	            
        	    rightPoly.setFilter(rightDimensionFilter);
            	lineParts[2] = rightPoly;
        	}
        }
        if (lineParts[2] == null)
        	mainPolyStr += tr_x + "," + tr_y + " ";
        mainPolyStr += br_x + "," + br_y + " " + bl_x + "," + bl_y + " ";
        if (lineParts[1] == null)
	        mainPolyStr += tl_x + "," + tl_y + " " + tr_x + "," + tr_y + " ";

        mainPoly.setPoints(mainPolyStr);
        return lineGroup.doImplementation(svgDocument);
    }

    /**
     * Returns the rightDimensionFilter.
     * @return String
     */
    public String getRightDimensionFilter() {
        return rightDimensionFilter;
    }

    /**
     * Returns the topDimensionFilter.
     * @return String
     */
    public String getTopDimensionFilter() {
        return topDimensionFilter;
    }

    /**
     * Sets the rightDimensionFilter.
     * @param rightDimensionFilter The rightDimensionFilter to set
     */
    public void setRightDimensionFilter(String rightDimensionFilter) {
        this.rightDimensionFilter = rightDimensionFilter;
    }

    /**
     * Sets the topDimensionFilter.
     * @param topDimensionFilter The topDimensionFilter to set
     */
    public void setTopDimensionFilter(String topDimensionFilter) {
        this.topDimensionFilter = topDimensionFilter;
    }

    /**
     * Returns the xMax.
     * @return double
     */
    public double getXMax() {
        return xMax;
    }

    /**
     * Returns the xMin.
     * @return double
     */
    public double getXMin() {
        return xMin;
    }

    /**
     * Returns the yMax.
     * @return double
     */
    public double getYMax() {
        return yMax;
    }

    /**
     * Returns the yMin.
     * @return double
     */
    public double getYMin() {
        return yMin;
    }

    /**
     * Sets the xMax.
     * @param xMax The xMax to set
     */
    public void setXMax(double xMax) {
        this.xMax = xMax;
    }

    /**
     * Sets the xMin.
     * @param xMin The xMin to set
     */
    public void setXMin(double xMin) {
        this.xMin = xMin;
    }

    /**
     * Sets the yMax.
     * @param yMax The yMax to set
     */
    public void setYMax(double yMax) {
        this.yMax = yMax;
    }

    /**
     * Sets the yMin.
     * @param yMin The yMin to set
     */
    public void setYMin(double yMin) {
        this.yMin = yMin;
    }

    /**
     * Returns the x3Doffset.
     * @return double
     */
    public double getX3Doffset() {
        return x3Doffset;
    }

    /**
     * Returns the y3Doffset.
     * @return double
     */
    public double getY3Doffset() {
        return y3Doffset;
    }

    /**
     * Sets the x3Doffset.
     * @param x3Doffset The x3Doffset to set
     */
    public void setX3Doffset(double x3Doffset) {
        this.x3Doffset = x3Doffset;
    }

    /**
     * Sets the y3Doffset.
     * @param y3Doffset The y3Doffset to set
     */
    public void setY3Doffset(double y3Doffset) {
        this.y3Doffset = y3Doffset;
    }

    /**
     * Returns the zeroYCoord.
     * @return double
     */
    public double getZeroYCoord() {
        return zeroYCoord;
    }

    /**
     * Sets the zeroYCoord.
     * @param zeroYCoord The zeroYCoord to set
     */
    public void setZeroYCoord(double zeroYCoord) {
        this.zeroYCoord = zeroYCoord;
    }

    /**
     * Returns the zeroXCoord.
     * @return double
     */
    public double getZeroXCoord() {
        return zeroXCoord;
    }

    /**
     * Sets the zeroXCoord.
     * @param zeroXCoord The zeroXCoord to set
     */
    public void setZeroXCoord(double zeroXCoord) {
        this.zeroXCoord = zeroXCoord;
    }

    /**
     * Returns the linear.
     * @return boolean
     */
    public boolean isLinear() {
        return linear;
    }

    /**
     * Sets the linear.
     * @param linear The linear to set
     */
    public void setLinear(boolean linear) {
        this.linear = linear;
    }
	/**
	 * Returns the isLTR.
	 * @return boolean
	 */
	public boolean isLTR() {
		return isLTR;
	}

	/**
	 * Sets the isLTR.
	 * @param isLTR The isLTR to set
	 */
	public void setIsLTR(boolean isLTR) {
		this.isLTR = isLTR;
	}

	/**
	 * Returns the isHorizontal.
	 * @return boolean
	 */
	public boolean isHorizontal() {
		return isHorizontal;
	}

	/**
	 * Sets the isHorizontal.
	 * @param isHorizontal The isHorizontal to set
	 */
	public void setIsHorizontal(boolean isHorizontal) {
		this.isHorizontal = isHorizontal;
	}

	/**
	 * Sets the plotHieght.
	 * @param plotHieght The plotHieght to set
	 */
	public void setPlotHieght(double plotHieght) {
		this.plotHieght = plotHieght;
	}

	/**
	 * Sets the plotWidth.
	 * @param plotWidth The plotWidth to set
	 */
	public void setPlotWidth(double plotWidth) {
		this.plotWidth = plotWidth;
	}

	/**
	 * Returns the isNeg.
	 * @return boolean
	 */
	public boolean isNeg() {
		return isNeg;
	}

	/**
	 * Sets the isNeg.
	 * @param isNeg The isNeg to set
	 */
	public void setIsNeg(boolean isNeg) {
		this.isNeg = isNeg;
	}

	/**
	 * Returns the stacked.
	 * @return boolean
	 */
	public boolean isStacked() {
		return stacked;
	}

	/**
	 * Sets the stacked.
	 * @param stacked The stacked to set
	 */
	public void setStacked(boolean stacked) {
		this.stacked = stacked;
	}

}
