/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MarkerLines.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MarkerLines.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.MarkerLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 * Lines that mark values on XY-charts
 */
public class MarkerLines extends Part {
	static final long serialVersionUID = 7569584230566675280L;	
	private Axis indepAxis = null;
	private AxisNumber primaryDepAxis = null;
	private AxisNumber secondaryDepAxis = null;

	private AxisDefinition indepAxisDef = null;
	private AxisDefinition primaryDepAxisDef = null;
	private AxisDefinition secondaryDepAxisDef = null;
	private String indepAxisPosition = null;

	private boolean isLTR = true;
	
	/**
	 * An object for retriving translated text
	 */
	protected NLString nls;
	
	/**
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 */
	public MarkerLines(Chart input, boolean isLTR, double x, double y, double width, double height, String indepAxisPosition, NLString nls) {
		super(input, x, y, width, height);
		this.indepAxisPosition = indepAxisPosition;
		this.isLTR = isLTR;
		this.nls = nls;
	}

	/**
	 * Set independent axis
	 * @param axis
	 */
	public void setIndepAxis(Axis axis) {
		indepAxis = axis;
	}

	/**
	 * Set primary dependent axis
	 * @param axis
	 */
	public void setPrimaryDepAxis(AxisNumber axis) {
		primaryDepAxis = axis;
	}

	/**
	 * Set secondary dependent axis
	 * @param axis
	 */
	public void setSecondaryDepAxis(AxisNumber axis) {
		secondaryDepAxis = axis;
	}

	/**
	 * Set independent axis definition
	 * @param axis
	 */
	public void setIndepAxisDef(AxisDefinition axisDef) {
		indepAxisDef = axisDef;
	}

	/**
	 * Set primary dependent axis definition
	 * @param axis
	 */
	public void setPrimaryDepAxisDef(AxisDefinition axisDef) {
		primaryDepAxisDef = axisDef;
	}

	/**
	 * Set secondary dependent axis definition
	 * @param axis
	 */
	public void setSecondaryDepAxisDef(AxisDefinition axisDef) {
		secondaryDepAxisDef = axisDef;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		Vector lineVector = new Vector();
		
		if (primaryDepAxisDef != null) {
			List markerLines = primaryDepAxisDef.getMarkerLine();
			for (Iterator i=markerLines.iterator(); i.hasNext();) {
				MarkerLine markerLine = (MarkerLine) i.next();
				if (indepAxisPosition.equals(POSITION_SOUTH) || 
					indepAxisPosition.equals(POSITION_NORTH)) {
					lineVector.add(drawHorizontalMarkerLine(primaryDepAxis, markerLine));
				} else {
					lineVector.add(drawVerticalMarkerLine(primaryDepAxis, markerLine));
				}
			}
		}

		if (secondaryDepAxisDef != null) {
			List markerLines = secondaryDepAxisDef.getMarkerLine();
			for (Iterator i=markerLines.iterator(); i.hasNext();) {
				MarkerLine markerLine = (MarkerLine) i.next();
				if (indepAxisPosition.equals(POSITION_SOUTH) || 
					indepAxisPosition.equals(POSITION_NORTH)) {
						lineVector.add(drawHorizontalMarkerLine(secondaryDepAxis, markerLine));
				} else {
					lineVector.add(drawVerticalMarkerLine(secondaryDepAxis, markerLine));
				}
			}
		}

		if (indepAxisDef != null && indepAxis instanceof AxisNumber) {
			List markerLines = indepAxisDef.getMarkerLine();
			for (Iterator i=markerLines.iterator(); i.hasNext();) {
				MarkerLine markerLine = (MarkerLine) i.next();
				if (indepAxisPosition.equals(POSITION_SOUTH) || 
					indepAxisPosition.equals(POSITION_NORTH)) {
						lineVector.add(drawVerticalMarkerLine((AxisNumber) indepAxis, markerLine));
				} else {
					lineVector.add(drawHorizontalMarkerLine((AxisNumber) indepAxis, markerLine));
				}
			}
		}
		
		SVGBase[] children = new SVGBase[lineVector.size()];
		for (int i=0; i<lineVector.size(); i++) {
			children[i] = (SVGBase) lineVector.elementAt(i);
		}
		setChildren(children);

	}

	private SVGBase drawHorizontalMarkerLine(AxisNumber axis, MarkerLine markerLine) {
		SVGGroup lineGroup = new SVGGroup();
		SVGBase[] groupMembers = new SVGBase[2];
		lineGroup.setChildren(groupMembers);
		SVGLine horizontalMarkerLine = new SVGLine();
		groupMembers[0] = horizontalMarkerLine;

		double value;
		double max_y = 0;
		double min_y = Double.parseDouble(getHeight());
		double max = axis.getMax();
		double min = axis.getMin();
		double y_coor;

		if (axis.isLinear) {
			value = markerLine.getValue();
		} else {
			if(markerLine.getValue() > 0){
			value = Math.log(markerLine.getValue()) / Math.log(10);
			}else{
				return lineGroup;
			}
		}
		y_coor = getCoordinate(value, max_y, min_y, max, min);
		horizontalMarkerLine.setX1("0");
		horizontalMarkerLine.setY1(Double.toString(y_coor));
		horizontalMarkerLine.setX2(getWidth());
		horizontalMarkerLine.setY2(Double.toString(y_coor));
		if (markerLine.isSetThickness()) {
			horizontalMarkerLine.setStrokeWidth(Double.toString(markerLine.getThickness()));
		} else {
			horizontalMarkerLine.setStrokeWidth("1.5");
		}
		if (markerLine.getColor() != null) {
			horizontalMarkerLine.setStroke(markerLine.getColor());
		} else {
			horizontalMarkerLine.setStroke(MARKER_LINE_DEFAULT_COLOR);
		}
		
		// add tooltip
		String label = nls.getString(markerLine.getLabel());
		if (label != null && label.length() != 0) {
			groupMembers[1] = EventTools.generateValueTooltip(lineGroup, label);
		}
		
		return lineGroup;
	}

	private SVGBase drawVerticalMarkerLine(AxisNumber axis, MarkerLine markerLine) {
		SVGGroup lineGroup = new SVGGroup();
		SVGBase[] groupMembers = new SVGBase[2];
		lineGroup.setChildren(groupMembers);
		SVGLine verticalMarkerLine = new SVGLine();
		groupMembers[0] = verticalMarkerLine;

		double value;
		double max_x = Double.parseDouble(getWidth());
		double min_x = 0;
		double max = axis.getMax();
		double min = axis.getMin();
		double x_coor;

		if (axis.isLinear) {
			value = markerLine.getValue();
		} else {
			if(markerLine.getValue() > 0){
				value = Math.log(markerLine.getValue()) / Math.log(10);
			}else{
				return lineGroup;
			}
		}
		if (isLTR) {
			x_coor = getCoordinate(value, max_x, min_x, max, min);
		} else {
			x_coor = getCoordinate(value, min_x, max_x, max, min);
		}
		verticalMarkerLine.setX1(Double.toString(x_coor));
		verticalMarkerLine.setY1("0");
		verticalMarkerLine.setX2(Double.toString(x_coor));
		verticalMarkerLine.setY2(getHeight());
		if (markerLine.isSetThickness()) {
			verticalMarkerLine.setStrokeWidth(Double.toString(markerLine.getThickness()));
		} else {
			verticalMarkerLine.setStrokeWidth("1.5");
		}
		if (markerLine.getColor() != null) {
			verticalMarkerLine.setStroke(markerLine.getColor());
		} else {
			verticalMarkerLine.setStroke(MARKER_LINE_DEFAULT_COLOR);
		}

		// add tooltip
		String label = nls.getString(markerLine.getLabel());
		if (label != null) {
			groupMembers[1] = EventTools.generateValueTooltip(lineGroup, label);
		}
		
		return lineGroup;
	}

	/**
	 * Calculate coordinate in linear scale
	 * @param value value to be plotted
	 * @param max_coor maximum coordinate of this axis
	 * @param min_coor minimum coordinate of this axis
	 * @param max maximum value of this axis
	 * @param min minimum value of this axis
	 * @return
	 */
	private double getCoordinate(double value, double max_coor, double min_coor, double max, double min) {
		return (value - max) / (min - max) * (min_coor - max_coor) + max_coor;
	}
}
