/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MarkerRegions.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MarkerRegions.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.MarkerRegion;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 * Mark intervals along a number axis on XY-charts
 */
public class MarkerRegions extends Part {
	static final long serialVersionUID = 7019534245475563145L;	
	private Axis indepAxis = null;
	private AxisNumber primaryDepAxis = null;
	private AxisNumber secondaryDepAxis = null;

	private AxisDefinition indepAxisDef = null;
	private AxisDefinition primaryDepAxisDef = null;
	private AxisDefinition secondaryDepAxisDef = null;
	private String indepAxisPosition = null;

	private boolean isLTR = true;
	
	/**
	 * An object for retriving translated text
	 */
	protected NLString nls;
	
	/**
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 */
	public MarkerRegions(Chart input, boolean isLTR, double x, double y, double width, double height, String indepAxisPosition, NLString nls) {
		super(input, x, y, width, height);
		this.indepAxisPosition = indepAxisPosition;
		this.isLTR = isLTR;
		this.nls = nls;
	}

	/**
	 * Set independent axis
	 * @param axis
	 */
	public void setIndepAxis(Axis axis) {
		indepAxis = axis;
	}

	/**
	 * Set primary dependent axis
	 * @param axis
	 */
	public void setPrimaryDepAxis(AxisNumber axis) {
		primaryDepAxis = axis;
	}

	/**
	 * Set secondary dependent axis
	 * @param axis
	 */
	public void setSecondaryDepAxis(AxisNumber axis) {
		secondaryDepAxis = axis;
	}

	/**
	 * Set independent axis definition
	 * @param axis
	 */
	public void setIndepAxisDef(AxisDefinition axisDef) {
		indepAxisDef = axisDef;
	}

	/**
	 * Set primary dependent axis definition
	 * @param axis
	 */
	public void setPrimaryDepAxisDef(AxisDefinition axisDef) {
		primaryDepAxisDef = axisDef;
	}

	/**
	 * Set secondary dependent axis definition
	 * @param axis
	 */
	public void setSecondaryDepAxisDef(AxisDefinition axisDef) {
		secondaryDepAxisDef = axisDef;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		Vector lineVector = new Vector();
		
		if (primaryDepAxisDef != null) {
			List markerRegions = primaryDepAxisDef.getMarkerRegion();
			for (Iterator i=markerRegions.iterator(); i.hasNext();) {
				MarkerRegion markerRegion = (MarkerRegion) i.next();
				if (indepAxisPosition.equals(POSITION_SOUTH) || 
					indepAxisPosition.equals(POSITION_NORTH)) {
					lineVector.add(drawHorizontalMarkerRegion(primaryDepAxis, markerRegion));
				} else {
					lineVector.add(drawVerticalMarkerRegion(primaryDepAxis, markerRegion));
				}
			}
		}

		if (secondaryDepAxisDef != null) {
			List markerRegions = secondaryDepAxisDef.getMarkerRegion();
			for (Iterator i=markerRegions.iterator(); i.hasNext();) {
				MarkerRegion markerRegion = (MarkerRegion) i.next();
				if (indepAxisPosition.equals(POSITION_SOUTH) || 
					indepAxisPosition.equals(POSITION_NORTH)) {
						lineVector.add(drawHorizontalMarkerRegion(secondaryDepAxis, markerRegion));
				} else {
					lineVector.add(drawVerticalMarkerRegion(secondaryDepAxis, markerRegion));
				}
			}
		}

		if (indepAxisDef != null && indepAxis instanceof AxisNumber) {
			List markerRegions = indepAxisDef.getMarkerRegion();
			for (Iterator i=markerRegions.iterator(); i.hasNext();) {
				MarkerRegion markerRegion = (MarkerRegion) i.next();
				if (indepAxisPosition.equals(POSITION_SOUTH) || 
					indepAxisPosition.equals(POSITION_NORTH)) {
						lineVector.add(drawVerticalMarkerRegion((AxisNumber) indepAxis, markerRegion));
				} else {
					lineVector.add(drawHorizontalMarkerRegion((AxisNumber) indepAxis, markerRegion));
				}
			}
		}
		
		SVGBase[] children = new SVGBase[lineVector.size()];
		for (int i=0; i<lineVector.size(); i++) {
			children[i] = (SVGBase) lineVector.elementAt(i);
		}
		setChildren(children);

	}

	private SVGBase drawHorizontalMarkerRegion(AxisNumber axis, MarkerRegion markerRegion) {
		SVGGroup regionGroup = new SVGGroup();
		SVGBase[] groupMembers = new SVGBase[2];
		regionGroup.setChildren(groupMembers);
		SVGRectangle horizontalMarkerRegion = new SVGRectangle();
		groupMembers[0] = horizontalMarkerRegion;

		double fromValue;
		double toValue;
		double max_y = 0;
		double min_y = Double.parseDouble(getHeight());
		double max = axis.getMax();
		double min = axis.getMin();
		double from_y_coor;
		double to_y_coor;

		if (axis.isLinear) {
			fromValue = markerRegion.getFromValue();
			toValue = markerRegion.getToValue();
		} else {
			if(markerRegion.getFromValue() > 0 && markerRegion.getToValue() > 0){
				fromValue = Math.log(markerRegion.getFromValue()) / Math.log(10);
				toValue = Math.log(markerRegion.getToValue()) / Math.log(10);
			}else{
				return regionGroup;
			}
		}

		from_y_coor = getCoordinate(fromValue, max_y, min_y, max, min);
		to_y_coor = getCoordinate(toValue, max_y, min_y, max, min);

		// make sure from y coordinate is smaller than to y coordinate
		if (to_y_coor < from_y_coor) {
			double tmp = to_y_coor;
			to_y_coor = from_y_coor;
			from_y_coor = tmp;
		}

		horizontalMarkerRegion.setXCoordinate("0");
		horizontalMarkerRegion.setYCoordinate(Double.toString(from_y_coor));
		horizontalMarkerRegion.setWidth(getWidth());
		horizontalMarkerRegion.setHeight(Double.toString(to_y_coor - from_y_coor));
		if (markerRegion.getColor() != null) {
			horizontalMarkerRegion.setStroke("none");
			horizontalMarkerRegion.setFill(markerRegion.getColor());
			horizontalMarkerRegion.setStyle("fill-opacity:0.3");
		} else {
			horizontalMarkerRegion.setStroke("none");
			horizontalMarkerRegion.setFill(MARKER_LINE_DEFAULT_COLOR);
			horizontalMarkerRegion.setStyle("fill-opacity:0.3");
		}
		
		// add label
		String labelText = nls.getString(markerRegion.getLabel());
		if (labelText != null && labelText.length() != 0) {
			SVGText label = new SVGText();
			label.setText(labelText);
			if (isLTR) {
				label.setXCoordinate("5");
				label.setYCoordinate(Double.toString(from_y_coor + 5 + BASE_FONT_SIZE));
			} else {
				label.setXCoordinate(Double.toString(width-5));
				label.setYCoordinate(Double.toString(from_y_coor + 5 + BASE_FONT_SIZE));
				label.setStyleClass("anchorAtEnd");
			}
			groupMembers[1] = label;
		}
		
		return regionGroup;
	}

	private SVGBase drawVerticalMarkerRegion(AxisNumber axis, MarkerRegion markerRegion) {
		SVGGroup regionGroup = new SVGGroup();
		SVGBase[] groupMembers = new SVGBase[2];
		regionGroup.setChildren(groupMembers);
		SVGRectangle verticalMarkerRegion = new SVGRectangle();
		groupMembers[0] = verticalMarkerRegion;

		double fromValue;
		double toValue;
		double max_x = Double.parseDouble(getWidth());
		double min_x = 0;
		double max = axis.getMax();
		double min = axis.getMin();
		double from_x_coor;
		double to_x_coor;

		if (axis.isLinear) {
			fromValue = markerRegion.getFromValue();
			toValue = markerRegion.getToValue();
		} else {
			if(markerRegion.getFromValue() > 0 && markerRegion.getToValue() > 0){
				fromValue = Math.log(markerRegion.getFromValue()) / Math.log(10);
				toValue = Math.log(markerRegion.getToValue()) / Math.log(10);
			} else {
				return regionGroup;
			}
		}

		if (isLTR) {
			from_x_coor = getCoordinate(fromValue, max_x, min_x, max, min);
			to_x_coor = getCoordinate(toValue, max_x, min_x, max, min);
		} else {
			from_x_coor = getCoordinate(fromValue, min_x, max_x, max, min);
			to_x_coor = getCoordinate(toValue, min_x, max_x, max, min);
		}
		
		// make sure from x coordinate is smaller than to x coordinate
		if (to_x_coor < from_x_coor) {
			double tmp = to_x_coor;
			to_x_coor = from_x_coor;
			from_x_coor = tmp;
		}

		verticalMarkerRegion.setXCoordinate(Double.toString(from_x_coor));
		verticalMarkerRegion.setYCoordinate("0");
		verticalMarkerRegion.setWidth(Double.toString(to_x_coor - from_x_coor));
		verticalMarkerRegion.setHeight(getHeight());
		if (markerRegion.getColor() != null) {
			verticalMarkerRegion.setStroke("none");
			verticalMarkerRegion.setFill(markerRegion.getColor());
			verticalMarkerRegion.setStyle("fill-opacity:0.3");
		} else {
			verticalMarkerRegion.setStroke("none");
			verticalMarkerRegion.setFill(MARKER_LINE_DEFAULT_COLOR);
			verticalMarkerRegion.setStyle("fill-opacity:0.3");
		}

		// add label
		String labelText = nls.getString(markerRegion.getLabel());
		if (labelText != null && labelText.length() != 0) {
			SVGText label = new SVGText();
			label.setText(labelText);
			if (isLTR) {
				label.setXCoordinate(Double.toString(from_x_coor + 5));
				label.setYCoordinate(Double.toString(5 + BASE_FONT_SIZE));
			} else {
				label.setXCoordinate(Double.toString(to_x_coor - 5));
				label.setYCoordinate(Double.toString(5 + BASE_FONT_SIZE));
				label.setStyleClass("anchorAtEnd");
			}
			groupMembers[1] = label;
		}
		return regionGroup;
	}

	/**
	 * Calculate coordinate in linear scale
	 * @param value value to be plotted
	 * @param max_coor maximum coordinate of this axis
	 * @param min_coor minimum coordinate of this axis
	 * @param max maximum value of this axis
	 * @param min minimum value of this axis
	 * @return
	 */
	private double getCoordinate(double value, double max_coor, double min_coor, double max, double min) {
		return (value - max) / (min - max) * (min_coor - max_coor) + max_coor;
	}
}
