/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Part.java,v 1.1 2005/03/30 08:26:41 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Part.java,v 1.1 2005/03/30 08:26:41 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGSvg;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;


/**
 *  
 */
public abstract class Part extends SVGSvg implements IConstants, IGraphicTypeConstants {
	
	protected Chart input;
	protected double x;
	protected double y;
	protected double width;
	protected double height;
	
	/**
	 * Constructor
	 * @param input
	 */
	public Part(Chart input) {
		super();
		this.input = input;
	}

	/**
	 * Constructor
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 */
	public Part(Chart input, double x, double y, double width, double height) {
		super();
		
		this.input = input;
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
		
		setXCoordinate(Double.toString(x));
		setYCoordinate(Double.toString(y));
		setWidth(Double.toString(width));
		setHeight(Double.toString(height));
	}
	
	/**
	 * Calls the superclass to create the SVG container element and then sets 
	 * any non-<code>null</code> base attributes.
	 * 
	 * @param Document the target SVG document.	
	 * @return Element the implementation element or <code>null</code> if the element was not created. 
	 */
	public Element doImplementation(Document svgDocument) {

		constructPart();

		Element svgElement = super.doImplementation(svgDocument);
		
		return svgElement;
	}	
	
	protected abstract void constructPart();
}
