/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PlotAreaBar.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PlotAreaBar.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 *
 * <code>PlotAreaBar</code> is the implementation of plot area for bar charts 
 * $Revision: 1.2 $  
 */

public class PlotAreaBar extends PlotAreaXY {
	static final long serialVersionUID = -698368106011605017L;
	protected double barMaxWidth = 40;	
	protected double barPosition;
	protected double barWidth = barMaxWidth;
	protected double groupInterval; 
	protected double barInterval;
	protected String indepAxisPosition;
	protected boolean useCategories;
	/**
	 * Text direction: true if LTR, false if RTL
	 */
	protected boolean isLTR = true;

	/**
	 * Constructor for PlotAreaBar
	 * @param input
	 * @param isLTR
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 * @param palettes
	 * @param indepAxisPosition
	 */
	public PlotAreaBar(Chart input, boolean isLTR, double x, double y, double width, double height,  SVGColorPalettes palettes, String indepAxisPosition, boolean useCategories, NLString nls) {
		super(input, x, y, width, height, nls);
		this.palettes = palettes;		
		this.indepAxisPosition = indepAxisPosition;
		this.isLTR = isLTR;	
		this.useCategories = useCategories;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.PlotAreaXY#getDataSet(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet, int, org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber)
	 */
	protected DataSet getDataSet(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset, int datasetIndex, AxisNumber depAxis) {
		String[] colors = palettes.getPalette();
		int colorIndex = datasetIndex % colors.length;
		if (numOfSets % 2 == 1) {
			barPosition = groupInterval / 2 - numOfSets / 2 * barInterval + datasetIndex * barInterval;
		} else {
			barPosition = groupInterval / 2 - numOfSets / 2 * barInterval + 0.5 * barInterval + datasetIndex * barInterval;
		}
		DataSet datasetPart;
		datasetPart = new DataSetBar(
						input, 
						isLTR, 
						(AxisCategory)indepAxis, 
						primaryDepAxis, 
						dataset,
						datasetIndex, 
						colorIndex, 
						barWidth, 
						barPosition, 
						groupInterval,
						palettes,
						nls);
		datasetPart.setHeight(getHeight());
		datasetPart.setWidth(getWidth());
		return datasetPart;
	}

	/**
	 * Overriding this method to set values in plot area for create data sets for bar chart.
	 *
	 */
	public void initPlotArea() {
		// Do initialization only if categories are defined.
		if (useCategories) {
			groupInterval = indepAxis.getAxisLength() / (double)((AxisCategory)indepAxis).categoryList.size();
			barInterval = groupInterval / (numOfSets+1.5);
			if (barMaxWidth < barInterval) {
				barInterval = barMaxWidth;
				barWidth = barInterval - 2;
			} else {
				barWidth = barInterval < 5 ? barInterval - 0.1 : barInterval - 1;
			}
		}
	}
}
