/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PlotAreaBar3D.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PlotAreaBar3D.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 * <code>PlotAreaBar3D</code> class creates a plot area to draw bars 
 * in a 3-D perspective. 
 */
public class PlotAreaBar3D extends PlotAreaBar {
    protected double y3Doffset;
    protected double x3Doffset;
    static final long serialVersionUID = 8618841665172409204L;

    /**
     * Constructor for PlotAreaBar
     * @param input
     * @param isLTR
     * @param x
     * @param y
     * @param width
     * @param height
     * @param palettes
     * @param indepAxisPosition
     */
    public PlotAreaBar3D(Chart input, boolean isLTR, double x, double y,
        double width, double height, SVGColorPalettes palettes,
        String indepAxisPosition, boolean useCategories, double x3Doffset,
        double y3Doffset, NLString nls) {
        super(input, isLTR, x, y, width, height, palettes, indepAxisPosition,
            useCategories, nls);
        this.y3Doffset = y3Doffset;
        this.x3Doffset = x3Doffset;
    }

    /**
     * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.PlotAreaXY#getDataSet(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet, int, org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber)
     */
    protected DataSet getDataSet(
        org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset, int datasetIndex,
        AxisNumber depAxis) {
        String[] colors = palettes.getPalette();
        int colorIndex = datasetIndex % colors.length;

        if ((numOfSets % 2) == 1) {
            barPosition = (groupInterval / 2) - (numOfSets / 2 * barInterval) +
                (datasetIndex * barInterval);
        } else {
            barPosition = (groupInterval / 2) - (numOfSets / 2 * barInterval) +
                (0.5 * barInterval) + (datasetIndex * barInterval);
        }

        DataSet datasetPart;
        datasetPart = new DataSetBar3D(input, isLTR, (AxisCategory) indepAxis,
                primaryDepAxis, dataset, datasetIndex, colorIndex, barWidth,
                barPosition, groupInterval, x3Doffset, y3Doffset, palettes, nls);
        datasetPart.setHeight(getHeight());
        datasetPart.setWidth(getWidth());

        return datasetPart;
    }
}
