/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PlotAreaLine.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PlotAreaLine.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.SVGShapeIterator;


/**
 * 
 */
public class PlotAreaLine extends PlotAreaXY {
	static final long serialVersionUID = 1554559120248875900L;
	private boolean useCategories;
	
	/**
	 * text direction: true is LTR, false is RTL
	 */
	protected boolean isLTR;
	
	protected SVGShapeIterator shapeIterator;
	
	/**
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 */
	public PlotAreaLine(
		Chart input,
		boolean isLTR,
		double x,
		double y,
		double width,
		double height,
		SVGColorPalettes palettes,
		SVGShapes shapes,
		boolean useCategories,
		NLString nls) {
			
		// A margin is left on all four sides of the plot area for line charts.
		// The margin is to prevent cutting off shapes at the edges of the plot area.
		super(input, x-PLOT_AREA_MARGIN, y-PLOT_AREA_MARGIN, width+PLOT_AREA_MARGIN*2, height+PLOT_AREA_MARGIN*2, nls);
		this.palettes = palettes;
		this.shapes = shapes;
		this.useCategories = useCategories;
		this.isLTR = isLTR;
		this.shapeIterator = shapes.getShapeIterator();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartXYPlotArea#getDataSet(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet, int)
	 */
	protected DataSet getDataSet(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset, int datasetIndex, AxisNumber depAxis) {
		// Get colors and shapes to be assigned to each data set (line)
		// Colors and shapes are assigned in the order specified in the datasets element
		// of the input xml.

		String[] colors = palettes.getPalette();
		
		int colorIndex = datasetIndex % colors.length;
		
		DataSet datasetPart;
		if (useCategories) {
			datasetPart = new DataSetLineCategory(
				input, 
				isLTR,
				indepAxis, 
				depAxis, 
				dataset,
				datasetIndex, 
				colorIndex, 
				palettes,
				shapeIterator.getNextShapeId(dataset.getId()),
				shapeIterator.getShapeWidth(),
				shapeIterator.getShapeHeight(),
				nls); 
		} else {
			datasetPart = new DataSetLineContinuum(
				input,
				isLTR, 
				indepAxis, 
				depAxis, 
				dataset,
				datasetIndex, 
				colorIndex, 
				palettes,
				shapeIterator.getNextShapeId(dataset.getId()),
				shapeIterator.getShapeWidth(),
				shapeIterator.getShapeHeight(),
				nls);
		}
		return datasetPart; 
	}
}
