/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PlotAreaPie3D.java,v 1.4 2008/12/12 22:22:09 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;


/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PlotAreaPie3D.java,v 1.4 2008/12/12 22:22:09 jcayne Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.util.Iterator;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLinearGradient;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPath;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGStop;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.FontHelper;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

import com.ibm.icu.util.ULocale;


/**
 * <code>PlotAreaPie3D</code> class creates a plot area to draw pie charts
 * in a 3-D perspective.
 */
public class PlotAreaPie3D extends PlotAreaPie {
	static final long serialVersionUID = -5473648900946305318L;
	/**
     * Constructor for PlotAreaPie3D.
     * @param input
     * @param x
     * @param y
     * @param width
     * @param height
     * @param palettes
     * @param locale
     */
    public PlotAreaPie3D(Chart input, double x, double y, double width,
        double height, SVGColorPalettes palettes, ULocale locale, NLString nls) {
        super(input, x, y, width, height, palettes, locale, nls);
    }

    protected DataSetPie getDatasetPie(Chart input, double cx, double cy,
        double radius, org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset,
        int datasetIndex, int colorIndex, CategoricalData[] sortedDatapoints,
        double pieValue, double previousDegree, ULocale locale, NLString nls) {    	
        return new DataSetPie3D(input, cx, cy, radius, dataset, datasetIndex,
            colorIndex, sortedDatapoints, pieValue, previousDegree, locale, palettes, nls);
    }

    /* (non-Javadoc)
     * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
     */
    protected void constructPart() {
        // centre points for everything
        double gWidth = width;
        double gHeight = height;
        double cx = gWidth / 2;
        double cy = gHeight / 2;
        double radius = (gHeight >= gWidth) ? (gWidth * 0.3) : (gHeight * 0.3);
        double pieValue = 0;
        double percent = 0;
        double previousDegree = 0;

        int numOfSets = 0;

        if (primaryDataSets != null) {
            numOfSets += primaryDataSets.size();
        }

        Data data = input.getData();
        DataSets datasets;
        List dataSetList = null;
        List categoryList;

        if (data != null) {
            datasets = data.getDataSets();

            Categories categories = data.getCategories();

            if (categories != null) {
                categoryList = categories.getCategory();
            }

            if (datasets != null) {
                dataSetList = datasets.getDataSet();
            }
        }

        // Each data set is a "part" of the plot area.
        // Each data set is represented by a pie.
        SVGBase[] parts = new SVGBase[numOfSets + 1]; //No of sataset 
        setChildren(parts);

        // This group is used to toggle data values
        SVGGroup group = new SVGGroup();
        group.setIdentifier("SVGGEN_datasetGroup");
        group.setChildren(parts);

        SVGBase[] groupChildren = new SVGBase[1];
        groupChildren[0] = group;

        setChildren(groupChildren);

        int curSetNum = 0;

        SVGGroup tickDefGroup = new SVGGroup();
        tickDefGroup.setIdentifier("tickline");

        SVGPolyline tickDef = new SVGPolyline();
        tickDef.setPoints("0 0 " + TICK_MARK_LENGTH + " 0"); // "0 0 5 0"
        tickDef.setStyleClass("axisTicks");
        tickDef.setIdentifier("tickline");
        addDefinition(tickDef);

        SVGLinearGradient linearGradient = new SVGLinearGradient();
        linearGradient.setIdentifier("pie-gradient");
        linearGradient.setX1(""+(-radius));
        linearGradient.setX2(""+radius);
        linearGradient.setY1("0");
        linearGradient.setY2("0");
        linearGradient.setGradientUnits("userSpaceOnUse");

        SVGStop[] stopPart = new SVGStop[3];
        SVGStop stop = new SVGStop();
        stop.setOffset("0");
        stop.setStyle("stop-color:#000000");
        stopPart[0] = stop;

        stop = new SVGStop();
        stop.setOffset(".25");
        stop.setStyle("stop-color:#FFFFFF");
        stopPart[1] = stop;

        stop = new SVGStop();
        stop.setOffset("1");
        stop.setStyle("stop-color:#000000");
        stopPart[2] = stop;

        linearGradient.setChildren(stopPart);

        addDefinition(linearGradient);

        String valueStr = null;
        String percentStr = null;
        String bothStr = null;

        if (primaryDataSets != null) {
            for (Iterator i = primaryDataSets.iterator(); i.hasNext();) {
                DataSet dataset = (DataSet) i.next();
                sortDataPoints(dataset);

                //Only positive value take in to account.
                if (sortedDatapoints[0] != null) {
                    if (sortedDatapoints[0].getValue() > 0) {
                        pieValue += sortedDatapoints[0].getValue();
                    }
                }
            }
            //update radius based on labels.
    		
    		double runningDeg = 0;
    		double oldRadius = radius;
    		FontHelper fontHelper = new FontHelper();
    		fontHelper.setFontSize(IConstants.BASE_FONT_SIZE);
    		
    		for (Iterator i = primaryDataSets.iterator(); i.hasNext(); ) {
    			DataSet dataset = (DataSet) i.next();	
    			sortDataPoints(dataset);
    			if((sortedDatapoints[0] != null ) && (sortedDatapoints[0].getValue() > 0)){				
    			double degrees = (360*sortedDatapoints[0].getValue()/pieValue)/2;
    			double percentage = sortedDatapoints[0].getValue()/pieValue*100;
    			double x1 = Math.cos(Math.PI/180*(degrees+runningDeg))*radius;
    			
    			String label = DataSetPie.formatValue(locale, input, percentage, sortedDatapoints[0].getValue());
    			double fontWidth = fontHelper.getStringWidth(label)+5;
    			//if (x1 < 0) fontWidth-=5;
    			fontWidth-=10;
    				double newRad = ((width/2) - fontWidth)/Math.cos(Math.PI/180*(degrees+runningDeg));
    				if (Math.abs(newRad) < oldRadius)
    					oldRadius = Math.abs(newRad);
    				runningDeg += (degrees*2);
    			}
    	}
    		radius = oldRadius;
    		  
            if (pieValue > 0 ) {
                //The depth is 30% of the radius
                double depth = radius * .3;
                String transformation = "translate(" + cx + "," + cy + ")";

                double degree = 360;
                String depthPath = "M " + (-radius) + " " + (depth) + " ";
                depthPath = "M " + (-radius) + " " + (depth) + " ";
                depthPath += (" A " + radius + " " + (radius / 2) + " 0 " +
                ((degree < 180) ? 0 : 1) + " 0 " + radius + " " + (depth));
                depthPath += (" L " + radius + " 0" + " A " + radius + " " +
                (radius / 2) + " 0 " + ((degree < 180) ? 0 : 1) + " 1 " +
                (-radius) + " " + "0 Z");

                SVGPath shadeSegment = new SVGPath();
                shadeSegment.setPathData(depthPath);
                shadeSegment.setTransform(transformation);
                shadeSegment.setStyle("fill: url(#pie-gradient)");
                parts[curSetNum++] = shadeSegment;
            }

            String[] colors = palettes.getPalette();

            for (Iterator i = primaryDataSets.iterator(); i.hasNext();) {
                DataSet dataset = (DataSet) i.next();
                sortDataPoints(dataset);

                if (sortedDatapoints[0] != null) {
                    int datasetIndex = dataSetList.indexOf(dataset);
                    int colorIndex = datasetIndex % colors.length;
                    DataSetPie pie = getDatasetPie(input, cx, cy, radius,
                            dataset, datasetIndex, colorIndex,
                            sortedDatapoints, pieValue, previousDegree, locale, nls);
                    pie.setWidth(getWidth());
                    pie.setHeight(getHeight());
                    parts[curSetNum++] = pie;
                    previousDegree += ((percent = (pieValue > 0)
                        ? (sortedDatapoints[0].getValue() / pieValue) : 0) * 360);
                }
            }
        }
    }
}
