/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PlotAreaStackBar.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.Iterator;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PlotAreaStackBar.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/



/**

 *
 * <code>PlotAreaStackBar</code> is class to create all the bars for bar chart. 
 * $Revision: 1.2 $  
 */
public class PlotAreaStackBar extends PlotArea {
	static final long serialVersionUID = 6518663084918465127L;

	// TODO SVGPartPlotArea should extend SVGPartXYPlotArea
	
	/**
	 * list of datasets
	 */
	protected AxisNumber primaryDepAxis = null;
	protected AxisCategory indepAxis = null;
	protected double barWidth = 0.0;
	protected double offset = 1.0;
	protected double groupOffset = 1.0;
	protected double barInterval;
	protected double[] accumulatedHighValues;	
	protected double[] accumulatedLowValues;			
	protected boolean useCategories;
	// TODO remove isLTR after the bar plot area becomes a subclass of SVGXYPlotArea
	// It is in the superclass.
	protected boolean isLTR = true;
		
	/**
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 */
	public PlotAreaStackBar(Chart input, boolean isLTR, double x, double y, double width, double height, SVGColorPalettes palettes, boolean useCategories, NLString nls) {
		super(input, x, y, width, height, nls);
		this.palettes = palettes;
		this.useCategories = useCategories;

		// TODO: remove the following line after this class becomes a subclass of XYPlotArea
		// TODO: make isLTR the second parameter when calling super(...)
		this.isLTR = isLTR;	
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		int numOfSets = 0;
		if (primaryDataSets != null) {
			numOfSets += primaryDataSets.size();
		}
		if (secondaryDataSets != null) {
			numOfSets += secondaryDataSets.size();
		}
		
		Data data = input.getData();
		DataSets datasets;
		List dataSetList = null;
		List categoryList;
		if (data != null) {
			datasets = data.getDataSets();
			Categories categories = data.getCategories();
			if (categories != null) {
				categoryList = categories.getCategory();
				accumulatedHighValues = new double[categoryList.size()];	
				accumulatedLowValues = new double[categoryList.size()];					
				for(int i=0; i < categoryList.size(); i++) {
					accumulatedHighValues[i] = Double.NaN;
					accumulatedLowValues[i] = Double.NaN;	
				}
			}
			if (datasets != null) {
				dataSetList = datasets.getDataSet();
			}
		}
		int curSetNum = 0;
		if(accumulatedHighValues != null){
			curSetNum = accumulatedHighValues.length;
		}
		// Each data set is a "part" of the plot area.
		// Each data set is represented by a bar.
		SVGBase[] parts = new SVGBase[numOfSets+curSetNum+1];

		// This group is used to toggle data values
		SVGGroup group = new SVGGroup();
		group.setIdentifier("SVGGEN_datasetGroup");
		group.setChildren(parts);

		SVGBase[] groupChildren = new SVGBase[1];
		groupChildren[0] = group;
		
		setChildren(groupChildren);
		
		// The last part is the group called "SVGGEN_plotareaForeground".
		// It is useful for bringing certain elements to the foreground
		// regardless of the drawing order.
		SVGGroup foreground = new SVGGroup();
		foreground.setIdentifier("SVGGEN_plotBarsForeground");
		parts[numOfSets+curSetNum] = foreground;
		
		// Get colors and shapes to be assigned to each data set (line)
		// Colors and shapes are assigned in the order specified in the datasets element
		// of the input xml. 
		String[] colors = palettes.getPalette();
		setBarWidth(numOfSets);
		if (primaryDataSets != null) {
			for (Iterator i = primaryDataSets.iterator(); i.hasNext(); ) {
				DataSet dataset = (DataSet) i.next();				
				int datasetIndex = dataSetList.indexOf(dataset);
				int colorIndex = datasetIndex % colors.length;
				DataSetStackBar bar = getDataSet(input, isLTR, indepAxis, primaryDepAxis, dataset, datasetIndex, colorIndex, barWidth, accumulatedLowValues, accumulatedHighValues);
				bar.setWidth(getWidth());
				bar.setHeight(getHeight());
				parts[curSetNum++] = bar;
			}
		}
		if(useCategories){
			double groupPosition[] = indepAxis.getGroupDataPositions();
			for (int i = 0; i < accumulatedHighValues.length; i++) {
				double total = 0;
				if ((Double.isNaN(accumulatedHighValues[i])) &&  (Double.isNaN(accumulatedLowValues[i])))
				    continue;
				else if (Double.isNaN(accumulatedLowValues[i]))
				   total = accumulatedHighValues[i];
				else if (Double.isNaN(accumulatedHighValues[i]))
				   total = accumulatedLowValues[i];
				else				   
				   total = accumulatedHighValues[i]+ accumulatedLowValues[i];
				double x, y;
				SVGText result = null;
				String tooltipID = "SVGGEN_datavalue" + EventTools.getUniqueID();
				SVGText tooltipText = new SVGText();
				tooltipText.setText(primaryDepAxis.formatValue(total));
				tooltipText.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
				tooltipText.setIdentifier(tooltipID);
				tooltipText.setVisibility("hidden");
				if(indepAxis.getAxisOrientation() == HORIZONTAL){
					tooltipText.setStyleClass("anchorAtMiddle");
					x =  groupPosition[i];
					if(total >= 0.0){
						y = (getCoordinate(primaryDepAxis.isLinear, accumulatedHighValues[i], 0.0, Double.parseDouble(getHeight()), primaryDepAxis.getMax(), primaryDepAxis.getMin()) - 2.0);						
					}else{
						y = (getCoordinate(primaryDepAxis.isLinear, accumulatedLowValues[i], 0.0, Double.parseDouble(getHeight()), primaryDepAxis.getMax(), primaryDepAxis.getMin()) + 10.0);
					}
				}else{
					if(isLTR){
						if(total >= 0.0){
							tooltipText.setStyleClass("anchorAtStart");
							x = (getCoordinate(primaryDepAxis.isLinear, accumulatedHighValues[i], Double.parseDouble(getWidth()),  0.0, primaryDepAxis.getMax(), primaryDepAxis.getMin()) + 2.0);
						}else{
							tooltipText.setStyleClass("anchorAtEnd");
							x = (getCoordinate(primaryDepAxis.isLinear, accumulatedLowValues[i], Double.parseDouble(getWidth()),  0.0, primaryDepAxis.getMax(), primaryDepAxis.getMin()) - 2.0);
						}
					}else{
						if(total >= 0.0){
							tooltipText.setStyleClass("anchorAtEnd");
							x = (getCoordinate(primaryDepAxis.isLinear, accumulatedHighValues[i], 0.0, Double.parseDouble(getWidth()), primaryDepAxis.getMax(), primaryDepAxis.getMin()) - 2.0);
						}else{
							tooltipText.setStyleClass("anchorAtStart");
							x = (getCoordinate(primaryDepAxis.isLinear, accumulatedLowValues[i], 0.0, Double.parseDouble(getWidth()), primaryDepAxis.getMax(), primaryDepAxis.getMin()) + 2.0);							
						}
					}
					y = indepAxis.getAxisLength()- groupPosition[i];
				}
				tooltipText.setXCoordinate(Double.toString(x));
				tooltipText.setYCoordinate(Double.toString(y));
				result = tooltipText;
				parts[i] = result;
			}
			if (data != null) {
				Categories categories = data.getCategories();
				if (categories != null) {
					categoryList = categories.getCategory();
					for(int i=0; i < categoryList.size(); i++) {
						accumulatedHighValues[i] = 0.0;
						accumulatedLowValues[i] = 0.0;	
					}
				}
			}
		}
	}
	
	/**
	 * Sets primary dependent axis
	 * @param axis
	 */
	public void setPrimaryDepAxis(AxisNumber axis) {
		primaryDepAxis = axis;
	}
	
	/**
	 * Sets independent axis
	 * @param axis
	 */
	public void setIndepAxis(AxisCategory axis) {
		indepAxis = axis;
	}

	/**
	 * @return
	 */
	public double getBarWidth() {
		return barWidth;
	}

	/**
	 * @param d
	 */
	public void setBarWidth(int numOfSets) {
		if(useCategories){
			barInterval = indepAxis.getAxisLength() / (double)indepAxis.categoryList.size(); 
			barWidth = barInterval-(2.0*offset);
			if(barWidth<1){
				offset = 0.1;
				barWidth = barInterval-offset;
			}
			barWidth = barWidth*0.8; 
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.PlotAreaXY#getDataSet(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet, int, org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber)
	 */
	protected DataSetStackBar getDataSet(
		Chart input, 
		boolean isLTR,
		AxisCategory indepAxis, 
		AxisNumber depAxis, 
		org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset, 
		int datasetIndex,
		int colorIndex,
		double barWidth,
		double[] accumulatedLowValues,
		double[] accumulatedHighValues)  {	 
		return new DataSetStackBar(input, isLTR, indepAxis, primaryDepAxis, dataset, datasetIndex, colorIndex, barWidth, accumulatedLowValues, accumulatedHighValues, palettes, nls);
	}
	
}

