/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PlotAreaStackBar3D.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PlotAreaStackBar3D.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/



import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

/**
 * <code>PlotAreaStackBar3D</code> class creates a plot area to draw stacked bars 
 * in a 3-D perspective. 
 */
public class PlotAreaStackBar3D extends PlotAreaStackBar {
    protected double y3Doffset;
    protected double x3Doffset;
    static final long serialVersionUID = -8285701343338422123L;
    /**
     * Constructor for PlotAreaBar
     * @param input
     * @param isLTR
     * @param x
     * @param y
     * @param width
     * @param height
     * @param palettes
     * @param indepAxisPosition
     */
    public PlotAreaStackBar3D(Chart input, boolean isLTR, double x, double y,
        double width, double height, SVGColorPalettes palettes,
        boolean useCategories, double x3Doffset, double y3Doffset, NLString nls) {
        super(input, isLTR, x, y, width, height, palettes, useCategories, nls);
        this.y3Doffset = y3Doffset;
        this.x3Doffset = x3Doffset;
    }

    /**
     * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
     */
    protected void constructPart() {
        int numOfSets = 0;

        if (primaryDataSets != null) {
            numOfSets += primaryDataSets.size();
        }

        if (secondaryDataSets != null) {
            numOfSets += secondaryDataSets.size();
        }

        Data data = input.getData();
        DataSets datasets;
        List dataSetList = null;
        List categoryList = null;

        if (data != null) {
            datasets = data.getDataSets();

            Categories categories = data.getCategories();

            if (categories != null) {
                categoryList = categories.getCategory();
                accumulatedHighValues = new double[categoryList.size()];
                accumulatedLowValues = new double[categoryList.size()];

                for (int i = 0; i < categoryList.size(); i++) {
                    accumulatedHighValues[i] = Double.NaN;
                    accumulatedLowValues[i] = Double.NaN;
                }
            }

            if (datasets != null) {
                dataSetList = datasets.getDataSet();
            }
        }

        int curSetNum = 0;

        if (accumulatedHighValues != null) {
            curSetNum = accumulatedHighValues.length;
        }

        // Each data set is a "part" of the plot area.
        // Each data set is represented by a bar.
        int categorySize = 0;
        if (categoryList != null)
        	categorySize = categoryList.size();
        SVGBase[] parts = new SVGBase[categorySize + curSetNum + 1];

        // This group is used to toggle data values
        SVGGroup group = new SVGGroup();
        group.setIdentifier("SVGGEN_datasetGroup");
        group.setChildren(parts);

        SVGBase[] groupChildren = new SVGBase[1];
        groupChildren[0] = group;

        setChildren(groupChildren);

        // The last part is the group called "SVGGEN_plotareaForeground".
        // It is useful for bringing certain elements to the foreground
        // regardless of the drawing order.
        SVGGroup foreground = new SVGGroup();
        foreground.setIdentifier("SVGGEN_plotBarsForeground");
        parts[categorySize + curSetNum] = foreground;

        // Get colors and shapes to be assigned to each data set (line)
        // Colors and shapes are assigned in the order specified in the datasets element
        // of the input xml. 
        String[] colors = palettes.getPalette();
        setBarWidth(numOfSets);

        if (primaryDataSets != null) {
            //			for (Iterator i = primaryDataSets.iterator(); i.hasNext(); ) {
            for (int i = 0; i < categorySize; i++) {
                //				org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset = (org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet) i.next();	
                //				int datasetIndex = dataSetList.indexOf(dataset);
                //				int colorIndex = datasetIndex % colors.length;
                DataSetStackBar3D bar = new DataSetStackBar3D(colors, input,
                        isLTR, indepAxis, primaryDepAxis, primaryDataSets,
                        categoryList.get(i), i, barWidth, accumulatedLowValues,
                        accumulatedHighValues, x3Doffset, y3Doffset, palettes, nls);
                bar.setWidth(getWidth());
                bar.setHeight(getHeight());
                parts[i] = bar;
            }
        }

        if (useCategories) {
            double[] groupPosition = indepAxis.getGroupDataPositions();

            for (int i = 0; i < accumulatedHighValues.length; i++) {
                double total = 0;
				if ((Double.isNaN(accumulatedHighValues[i])) &&  (Double.isNaN(accumulatedLowValues[i])))
				    continue;
				else if (Double.isNaN(accumulatedLowValues[i]))
				   total = accumulatedHighValues[i];
				else if (Double.isNaN(accumulatedHighValues[i]))
				   total = accumulatedLowValues[i];
				else				   
				   total = accumulatedHighValues[i]+ accumulatedLowValues[i];
                double x;
                double y;
                SVGText result = null;
                String tooltipID = "SVGGEN_datavalue" +
                    EventTools.getUniqueID();
                SVGText tooltipText = new SVGText();
                tooltipText.setText(primaryDepAxis.formatValue(total));
				tooltipText.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
                tooltipText.setIdentifier(tooltipID);
                tooltipText.setVisibility("hidden");

                if (indepAxis.getAxisOrientation() == HORIZONTAL) {
                    tooltipText.setStyleClass("anchorAtMiddle");
                    x = groupPosition[i];

                    if (total >= 0.0) {
                        y = (getCoordinate(primaryDepAxis.isLinear,
                                accumulatedHighValues[i], 0.0,
                                Double.parseDouble(getHeight()) - y3Doffset,
                                primaryDepAxis.getMax(), primaryDepAxis.getMin()) -
                            2.0);
                    } else {
                        y = (getCoordinate(primaryDepAxis.isLinear,
                                accumulatedLowValues[i], 0.0,
                                Double.parseDouble(getHeight()) - y3Doffset,
                                primaryDepAxis.getMax(), primaryDepAxis.getMin()) +
                            10.0 + y3Doffset);
                    }
                } else {
                    if (isLTR) {
                        if (total >= 0.0) {
                            tooltipText.setStyleClass("anchorAtStart");
                            x = (getCoordinate(primaryDepAxis.isLinear,
                                    accumulatedHighValues[i],
                                    Double.parseDouble(getWidth()) - x3Doffset,
                                    0.0, primaryDepAxis.getMax(),
                                    primaryDepAxis.getMin()) + 2.0 + x3Doffset);
                        } else {
                            tooltipText.setStyleClass("anchorAtEnd");
                            x = (getCoordinate(primaryDepAxis.isLinear,
                                    accumulatedLowValues[i],
                                    Double.parseDouble(getWidth()) - x3Doffset,
                                    0.0, primaryDepAxis.getMax(),
                                    primaryDepAxis.getMin()) - 2.0);
                        }
                    } else {
                        if (total >= 0.0) {
                            tooltipText.setStyleClass("anchorAtEnd");
                            x = (getCoordinate(primaryDepAxis.isLinear,
                                    accumulatedHighValues[i], 0.0,
                                    Double.parseDouble(getWidth()) - x3Doffset,
                                    primaryDepAxis.getMax(),
                                    primaryDepAxis.getMin()) - 2.0);
                        } else {
                            tooltipText.setStyleClass("anchorAtStart");
                            x = (getCoordinate(primaryDepAxis.isLinear,
                                    accumulatedLowValues[i], 0.0,
                                    Double.parseDouble(getWidth()) - x3Doffset,
                                    primaryDepAxis.getMax(),
                                    primaryDepAxis.getMin()) + 2.0 + x3Doffset);
                        }
                    }

                    y = indepAxis.getAxisLength() - groupPosition[i] +
                        y3Doffset;
                }

                tooltipText.setXCoordinate(Double.toString(x));
                tooltipText.setYCoordinate(Double.toString(y));
                result = tooltipText;
                parts[i+curSetNum] = result;
            }

            if (data != null) {
                Categories categories = data.getCategories();

                if (categories != null) {
                    categoryList = categories.getCategory();

                    for (int i = 0; i < categorySize; i++) {
                        accumulatedHighValues[i] = 0.0;
                        accumulatedLowValues[i] = 0.0;
                    }
                }
            }
        }
    }
}
