/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PlotAreaXY.java,v 1.1 2005/03/30 08:26:41 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PlotAreaXY.java,v 1.1 2005/03/30 08:26:41 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.util.Iterator;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGCircle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGClipPath;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGScript;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 * Plot area for XY charts
 */
public abstract class PlotAreaXY extends PlotArea {

	/**
	 * list of datasets
	 */
	protected AxisNumber primaryDepAxis = null;
	protected AxisNumber secondaryDepAxis = null;
	protected Axis indepAxis = null;
	protected int numOfSets = 0;

	double[] accumulatedHighValues;	
	double[] accumulatedLowValues;
	/**
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 */
	public PlotAreaXY(Chart input, double x, double y, double width, double height, NLString nls) {
		super(input, x, y, width, height, nls);
	}

	protected abstract DataSet getDataSet(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset, int datasetIndex, AxisNumber depAxis);

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		if (primaryDataSets != null) {
			numOfSets += primaryDataSets.size();
		}
		if (secondaryDataSets != null) {
			numOfSets += secondaryDataSets.size();
		}
		
		Data data = input.getData();
		DataSets datasets;
		List dataSetList = null;
		List categoryList;
		// Each data set is a "part" of the plot area.
		SVGBase[] parts = new SVGBase[(numOfSets*2)+3];
		if (data != null) {
			datasets = data.getDataSets();
			if (datasets != null) {
				dataSetList = datasets.getDataSet();
			}
			//Initialize stacked arrays to min values of primaryDepAxis.
			if(input.getType().equals(STACK_AREA_CHART)){
			
				double min = Math.pow(10.0, primaryDepAxis.getMin());
				double value = primaryDepAxis.isLinear() ? 0.0 : min;
				double zero_y = getCoordinate(primaryDepAxis.isLinear(), value, 0.0, primaryDepAxis.getAxisLength(), primaryDepAxis.getMax(), primaryDepAxis.getMin());
									
				StringBuffer yBasePoint = new StringBuffer("var minBase = " + value + "; var yBasePoint = " + zero_y +";");
				SVGScript scriptEmitter = new SVGScript();
				StringBuffer setDatasetArray = new StringBuffer("var xpts; var incl = new Array(true");
				for (int i = 1; i < numOfSets; i++) {
					setDatasetArray.append("," + "true");
				}
				setDatasetArray.append(");");
				EventTools.generateStackAreaJSFunction(scriptEmitter, setDatasetArray.toString());
							
				Categories categories = data.getCategories();
				if (categories != null) {
					categoryList = categories.getCategory();
					accumulatedHighValues = new double[categoryList.size()];	
					accumulatedLowValues = new double[categoryList.size()];	
				}
				
				EventTools.generateStackAreaJSFunction(scriptEmitter, setDatasetArray.toString()+yBasePoint.toString());
				parts[numOfSets*2+2] = scriptEmitter;
			}
		}
		
	
		// This group is used to toggle data values
		SVGGroup group = new SVGGroup();
		group.setIdentifier("SVGGEN_datasetGroup");
		group.setChildren(parts);
		
		// define hole shape
		SVGCircle circle = new SVGCircle();
		circle.setRadius(Double.toString(HOLE_RADIUS));
		circle.setCx(Double.toString(HOLE_RADIUS));
		circle.setCy(Double.toString(HOLE_RADIUS));
		circle.setStyle("stroke-width:0.75;fill:none;");
		circle.setIdentifier("SVGGEN_holeshape");
		addDefinition(circle);
		
		SVGBase[] groupChildren = new SVGBase[1];
		groupChildren[0] = group;
		
		setChildren(groupChildren);

		if (input.getType().equals(LINE_CHART) ||
			input.getType().equals(AREA_CHART) ||
			input.getType().equals(STACK_AREA_CHART) ||
			input.getType().equals(SCATTER_CHART)) {
			
			SVGClipPath clipPath = new SVGClipPath();
			clipPath.setIdentifier("SVGGEN_plotareaBorder");
			SVGBase[] clipPathChildren = new SVGBase[1];
			clipPath.setChildren(clipPathChildren);

			SVGRectangle border = new SVGRectangle();
			border.setXCoordinate("0");
			border.setYCoordinate("0");
			border.setWidth(Double.toString(width - PLOT_AREA_MARGIN * 2));
			border.setHeight(Double.toString(height - PLOT_AREA_MARGIN * 2));
			clipPathChildren[0] = border;
			
			addDefinition(clipPath);
		}

		// The first part is the group called "SVGGEN_plotareaBackground".
		// It is useful for bringing certain elements to the background
		// regardless of the drawing order.
		SVGGroup bkground = new SVGGroup();
		if (input.getType().equals(LINE_CHART) ||
			input.getType().equals(AREA_CHART) ||
			input.getType().equals(STACK_AREA_CHART) ||
			input.getType().equals(SCATTER_CHART)) {
			
			bkground.setStyle("clip-path: url(#SVGGEN_plotareaBorder)");	
		}
		bkground.setIdentifier("SVGGEN_plotareaBackground");
		
		if (input.getType().equals(AREA_CHART) || input.getType().equals(STACK_AREA_CHART)) {
			bkground.setTransformation("translate("+PLOT_AREA_MARGIN+","+PLOT_AREA_MARGIN+")");
		}
		parts[0] = bkground;

		
		int curSetNum = 1;
		
		initPlotArea();
		if (primaryDataSets != null) {
			for (Iterator i = primaryDataSets.iterator(); i.hasNext(); ) {
				org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset = 
					(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet) i.next();
				int datasetIndex = dataSetList.indexOf(dataset);
				
				SVGGroup foreground = new SVGGroup();
				foreground.setIdentifier("SVGGEN_plotareaForeground_"+dataset.getId());
				parts[numOfSets+curSetNum] = foreground;				
				
				DataSet datasetPart = getDataSet(dataset, datasetIndex, primaryDepAxis);
				parts[curSetNum++] = datasetPart;
			}
		}
		if (secondaryDataSets != null) {
			for (Iterator i = secondaryDataSets.iterator(); i.hasNext(); ) {
				org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset = 
					(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet) i.next();
				int datasetIndex = dataSetList.indexOf(dataset);
				SVGGroup foreground = new SVGGroup();
				foreground.setIdentifier("SVGGEN_plotareaForeground_"+dataset.getId());
				parts[numOfSets+curSetNum] = foreground;				
				

				DataSet datasetPart = getDataSet(dataset, datasetIndex, secondaryDepAxis);
				parts[curSetNum++] = datasetPart;
			}
		}
	}
	
	/**
	 * Sets primary dependent axis
	 * @param axis
	 */
	public void setPrimaryDepAxis(AxisNumber axis) {
		primaryDepAxis = axis;
	}
	
	/**
	 * Sets secondary dependent axis
	 * @param axis
	 */
	public void setSecondaryDepAxis(AxisNumber axis) {
		secondaryDepAxis = axis;
	}
	
	/**
	 * Sets independent axis
	 * @param axis
	 */
	public void setIndepAxis(Axis axis) {
		indepAxis = axis;
	}
	
	/**
	 * Override this method to set values in plot area for create data sets.
	 *
	 */
	protected void initPlotArea() {
		//empty
	}
}
