/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PreferenceIcon.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PreferenceIcon.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPath;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;


/**
 * Adds a definition for the user preferences graphic.

 */
public class PreferenceIcon extends Part{

	static final long serialVersionUID = 3001578782920980161L;
	/**
	 * @param input
	 */
	public PreferenceIcon(Chart input) {
		super(input);
	}
	
	/**
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 */
	public PreferenceIcon(Chart input, double x, double y, double width, double height) {
		super(input, x, y, width, height);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		
//		create  Preferences Icon	
		SVGGroup prefGroup = new SVGGroup();
		SVGBase[] prefParts = new SVGBase[2]; //Pref ID G/ICON G		
		prefGroup.setIdentifier("preferences");
		prefGroup.setChildren(prefParts);
		addDefinition(prefGroup);
		SVGGroup iconGroup = new SVGGroup();
		iconGroup.setIdentifier("graph");
		iconGroup.setStyle("fill-rule:nonzero;clip-rule:nonzero;fill:none;stroke:#999999;stroke-miterlimit:4;");
		prefParts[1] = iconGroup;

		SVGBase[] iconParts = new SVGBase[11]; //icon1Path to icon10Path
		iconGroup.setChildren(iconParts);
		SVGRectangle rect = new SVGRectangle();
		rect.setHeight("25");
		rect.setXCoordinate("-1");
		rect.setYCoordinate("-1");
		rect.setWidth("32");
		rect.setStyle("fill:#e4e4e4;stroke-width:0");
		iconParts[0] = rect;
		SVGPath icon1Path = new SVGPath();
		icon1Path.setPathData("M2.042,4.811H0.5v18h21v-6.542");
		iconParts[1] = icon1Path;
		SVGPath icon2Path = new SVGPath();
		icon2Path.setPathData("M2.042,4.811H0.5");
		iconParts[2] = icon2Path;
		SVGPath icon3Path = new SVGPath();
		icon3Path.setPathData("M2.042,10.801H0.5");	
		iconParts[3] = icon3Path;			
		SVGPath icon4Path = new SVGPath();
		icon4Path.setPathData("M2.042,16.8H0.5");
		iconParts[4] = icon4Path;
		SVGPath icon5Path = new SVGPath();
		icon5Path.setPathData("M6.51,22.81v-18H3.521v18H6.51z");
		icon5Path.setStyle("fill:#000099;");
		iconParts[5] = icon5Path;
		SVGPath icon6Path = new SVGPath();
		icon6Path.setPathData("M12.51,22.81v-11H9.521v11h2.989z");
		icon6Path.setStyle("fill:#0066CC;");
		iconParts[6] = icon6Path;		
		SVGPath icon7Path = new SVGPath();
		icon7Path.setPathData("M18.51,22.81v-5h-2.989v5h2.989z");		
		icon7Path.setStyle("fill:#99CCFF;");
		iconParts[7] = icon7Path;			
		SVGPath icon8Path = new SVGPath();
		icon8Path.setPathData("M21.532,7.842l-5.145-5.248c-1.295,1.295-2.096,3.083-2.096,5.06c0,3.953,3.286,7.156,7.238,7.156l0.002-6.968z");
		icon8Path.setStyle("fill:#0066CC;");
		iconParts[8] = icon8Path;
		SVGPath icon9Path = new SVGPath();
		icon9Path.setPathData("M21.557,14.81c3.952,0,7.047-3.11,7.047-7.063h-7.047v7.063z");
		icon9Path.setStyle("fill:#0066CC;");
		iconParts[9] = icon9Path;
		SVGPath icon10Path = new SVGPath();
		icon10Path.setPathData("M28.604,7.654c0-3.953-3.204-7.156-7.156-7.156c-1.977,0-3.766,0.801-5.061,2.097l5.092,5.278h7.125");
		icon10Path.setStyle("fill:#99CCFF;");
		iconParts[10] = icon10Path;
	}


}
