/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Title.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Title.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Preferences;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.TitleBar;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 * <code>Title</code> is class to add the Title part for each svg graph 
 * $Revision: 1.2 $  
 */

public class Title extends Part {
	static final long serialVersionUID = 7371525869612526897L;
	/**
	 * Title text
	 */
	private String title;

	/**
	 * Preference Icon flag. false by default
	 */
	private boolean prefIconShow = false;
		
	
	/**
	 * pointer to the title bar configuration
	 */
	private TitleBar titleBar;
	
	/**
	 * text direction setting, true if LTR, false if RTL
	 */
	private boolean isLTR;
	
	/**
	 * An object for retriving translated text
	 */
	private NLString nls;
	
	/**
	 * @param input Chart
	 * @param x position for title
	 * @param y position for title
	 * @param width position for title
	 * @param height position for title
	 */
	public Title(Chart input, boolean isLTR, double x, double y, double width, double height, NLString nls) {
		super(input, x, y, width, height);
		
		this.isLTR = isLTR;
		this.nls = nls;
		Configuration config = input.getConfiguration();
		//preference icon is NOT SHOWN by default 
		if (config != null) {
			Preferences pref = config.getPreferences();
			titleBar = config.getTitleBar();
			if (titleBar != null) {
				title = titleBar.getLabel();
			}
			if (pref != null) {
				// preferences is not shown by default  
				if (pref.isSetShow() && pref.isShow()) {
					prefIconShow = true;
				}
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		int noOfParts = 5; 
		SVGBase[] children = new SVGBase[noOfParts];
		SVGGroup group = new SVGGroup();
		group.setChildren(children);
		
		SVGBase[] groupChild = new SVGBase[2];
		groupChild[0] = group;

		if(prefIconShow){
			//Add preference icon if it is set in the input.
			PreferenceIcon prefIcon = new PreferenceIcon(input, x + 300, y, width, height);
			children[4] = prefIcon;

			SVGGroup outlineGroup = new SVGGroup();
			outlineGroup.setIdentifier("preferencesOutlineIconHoverBox");
			outlineGroup.setStyle("stroke-width:1;stroke:#a0a0a4");

			SVGBase[] outlineGroupChild = new SVGBase[4];
			outlineGroup.setChildren(outlineGroupChild);

			SVGGroup iconGroup = new SVGGroup();
			SVGBase[] iconGroupChild = new SVGBase[3];						
			iconGroup.setChildren(iconGroupChild);
			
			iconGroupChild[0] = outlineGroup;
			
			SVGUse iconUse = new SVGUse();
			iconUse.setHref("#preferences");
			iconUse.setIdentifier("preferencesIconHoverBox");
			
			double xCoord = 0;
			double yCoord = 0;
			if (isLTR) {
				xCoord = width - TITLE_SIDE_MARGIN - TITLE_PREF_ICON_WIDTH;
				yCoord = height/2 - TITLE_PREF_ICON_HEIGHT/2;	
				iconUse.setXCoordinate(Double.toString(width - TITLE_SIDE_MARGIN - TITLE_PREF_ICON_WIDTH));
				iconUse.setYCoordinate(Double.toString(height/2 - TITLE_PREF_ICON_HEIGHT/2));
			} else {
				xCoord = TITLE_SIDE_MARGIN;
				yCoord = height/2 - TITLE_PREF_ICON_HEIGHT/2;	
				// TODO test RTL setting for pref icon
				iconUse.setXCoordinate(Double.toString(TITLE_SIDE_MARGIN));
				iconUse.setYCoordinate(Double.toString(height/2 - TITLE_PREF_ICON_HEIGHT/2));
			}

			SVGLine line = new SVGLine();
			line.setX1((xCoord-2)+"");
			line.setX2((xCoord+32)+"");
			line.setY1((yCoord-2.5)+"");
			line.setY2((yCoord-2.5)+"");
			outlineGroupChild[0] = line;
			line = new SVGLine();
			line.setX1((xCoord-2.5)+"");
			line.setX2((xCoord-2.5)+"");
			line.setY1((yCoord-2)+"");
			line.setY2((yCoord+25)+"");
			outlineGroupChild[1] = line;
			line = new SVGLine();
			line.setX1((xCoord+32.5)+"");
			line.setX2((xCoord+32.5)+"");
			line.setY1((yCoord-2)+"");
			line.setY2((yCoord+25)+"");
			outlineGroupChild[2] = line;
			line = new SVGLine();
			line.setX1((xCoord-2)+"");
			line.setX2((xCoord+32)+"");
			line.setY1((yCoord+25.5)+"");
			line.setY2((yCoord+25.5)+"");
			outlineGroupChild[3] = line;


			iconGroupChild[1] = iconUse;
			groupChild[1] = iconGroup;

			// User preference events
			iconGroup.addEvent("onclick", "SVGGEN_openPreferencePage()");
			// User preference tooltip
			String tooltipID = "SVGGEN_tooltip" + EventTools.getUniqueID();
			String tooltipString = "User Preferences";
			if (input.getConfiguration() != null && input.getConfiguration().getPreferences() != null && input.getConfiguration().getPreferences().getTooltip() != null) {
				tooltipString = input.getConfiguration().getPreferences().getTooltip().getLabel();
			
				SVGGroup toolTipGroup = new SVGGroup();
				SVGBase[] toolTips = new SVGBase[2];
				toolTipGroup.setChildren(toolTips);
				toolTipGroup.setVisibility("hidden");
				
				SVGText tooltipText = new SVGText();
				tooltipText.setText(nls.getString(tooltipString));
				tooltipText.setIdentifier(tooltipID + "text");
				toolTips[0] = tooltipText;
			
				SVGRectangle tooltipRect = new SVGRectangle();
				tooltipRect.setIdentifier(tooltipID + "rect");
				tooltipRect.setXCoordinate("0");
				tooltipRect.setYCoordinate("0");
				tooltipRect.setWidth("0");
				tooltipRect.setHeight("0");
				toolTips[1] = tooltipRect;
			
				iconGroupChild[2] = toolTipGroup;
				
				
				iconGroup.addEvent("onmouseover", "SVGGEN_showTooltip(evt,'"+tooltipID+"');SVGGEN_PreferenceOnOut(evt,'preferencesOutlineIconHoverBox')");
				iconGroup.addEvent("onmouseout", "SVGGEN_hideTooltip(evt,'"+tooltipID+"');SVGGEN_PreferenceOnHover(evt,'preferencesOutlineIconHoverBox')");
			}
			else{
				iconGroup.addEvent("onmouseout","SVGGEN_PreferenceOnOut(evt,'preferencesOutlineIconHoverBox')");
				iconGroup.addEvent("onmouseover","SVGGEN_PreferenceOnHover(evt,'preferencesOutlineIconHoverBox')");
			}
		}

			setChildren(groupChild);
			
		//add title under line if preference icon or title is set.
		// Draw line by default, don't draw if "withSeparator" is set to false
		if(titleBar != null && titleBar.isSetWithSeparator() && !titleBar.isWithSeparator()){
			// Do not draw the line separator
		}else{
			SVGPolyline titleUnderLine = new SVGPolyline();
			//titleUnderLine.setStyleClass("keyline");
			titleUnderLine.setStroke("#666666");
			// Draw the line 1 pixel above the edge of the svg for Batik transcoding to work.
			String points = "0 " + (height-1) + " " + getWidth() + " " + (height-1);
			titleUnderLine.setPoints(points.toString());
			children[1] = titleUnderLine;
		}

		//Add tile if title is set.
		// Handle background color
		if(titleBar != null){
			if (titleBar.getBackgroundColor() != null && titleBar.getBackgroundColor().equals("") == false) {
					SVGRectangle bkground = new SVGRectangle();
					bkground.setXCoordinate("0");
					bkground.setYCoordinate("0");
					bkground.setWidth(getWidth());
					bkground.setHeight(getHeight());
					bkground.setFill(titleBar.getBackgroundColor());
					children[0] = bkground;
			}
			if (title != null) {
				if(title != EMPTY_STRING){
					SVGText graphTitle = new SVGText(); 
					graphTitle.setText(nls.getString(title));
					if (isLTR) {
						graphTitle.setXCoordinate(Double.toString(TITLE_SIDE_MARGIN)); // left margin, constant
						graphTitle.setYCoordinate(Double.toString(height/2 + TITLE_FONT_SIZE/2));
						graphTitle.setStyleClass("graphTitle");
						graphTitle.setIdentifier("SVGGEN_graphTitle");
					} else {
						// TODO test LTR setting
						graphTitle.setXCoordinate(Double.toString(width - TITLE_SIDE_MARGIN)); // left margin, constant
						graphTitle.setYCoordinate(Double.toString(height/2 + TITLE_FONT_SIZE/2));
						graphTitle.setStyleClass("graphTitle anchorAtEnd");
						graphTitle.setIdentifier("SVGGEN_graphTitle");
					}
		
					children[3] = graphTitle;
					
					// Handle user tooltips
					children[2] = EventTools.generateUserTooltip(group, titleBar.getTooltip(), nls);
		
					// Handle user events
					EventTools.generateUserEvents(group, titleBar.getEventHandler());
					
					// Handle accessibility
					EventTools.generateAccessibility(group, titleBar.getAccessibility(), nls);								
				}
			}
		}
	}
}
