/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TooltipPlaceholder.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TooltipPlaceholder.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;


/**
 * Generates a placeholder for tooltips
 */
public class TooltipPlaceholder extends Part {
	static final long serialVersionUID = -1518914323228639750L;
	TooltipPlaceholder(Chart input, double x, double y, double width, double height) {
		super(input, x, y, width, height);	
		
		SVGBase[] children = new SVGBase[2];
		
		SVGRectangle boundary = new SVGRectangle();
		boundary.setXCoordinate("0");
		boundary.setYCoordinate("0");
		boundary.setWidth(Double.toString(width));
		boundary.setHeight(Double.toString(height));
		boundary.setIdentifier("SVGGEN_boundary");
		boundary.setVisibility("hidden");
		children[0] = boundary;
		
		SVGGroup tooltipGroup = new SVGGroup();
		tooltipGroup.setIdentifier("SVGGEN_tooltips");
		children[1] = tooltipGroup;
		
		setChildren(children);	
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		// Do nothing
	}

}
