/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ElementList.java,v 1.2 2005/06/10 14:03:15 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ElementList.java,v 1.2 2005/06/10 14:03:15 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.w3c.dom.Element;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.InputBase;

/**
 * The Element represents an XML Element. When an object is added to the list, 
 * the object will also be appended to the child list of the Element object.
 */
public class ElementList extends ArrayList {

	/**
     * 
     */
    private static final long serialVersionUID = 1L;
    private Element _element;
	private String _tagName;
	private InputBase _inputObj;
	
//	public ElementList(Element element, String tagName) {
//		_element = element;
//		_tagName = tagName;
//	}
	
	public ElementList(InputBase inputObj, String tagName) {
		_inputObj = inputObj;
		_element = inputObj.getElement();
		_tagName = tagName;
	}

	/* (non-Javadoc)
	 * @see java.util.List#add(int, java.lang.Object)
	 */
	public void add(int index, Object o) {
		add(index, o, true);
	}
	
	public void add(int index, Object o, boolean updateDOM) {
		if (updateDOM && _element != null) {
			addElement(o);
		}
		super.add(index, o);
	}

	/* (non-Javadoc)
	 * @see java.util.Collection#add(java.lang.Object)
	 */
	public boolean add(Object o) {
		return add(o, true);
	}
	
	public boolean add(Object o, boolean updateDOM) {
		if (updateDOM && _element != null) {
			addElement(o);
		}
		return super.add(o);
	}

	/* (non-Javadoc)
	 * @see java.util.Collection#addAll(java.util.Collection)
	 */
	public boolean addAll(Collection c) {
		return addAll(c, true);
	}
	
	public boolean addAll(Collection c, boolean updateDOM) {
		if (updateDOM && _element != null) {
			for (Iterator iter = c.iterator(); iter.hasNext();) {
				addElement(iter.next());
			}
		}
		return super.addAll(c);
	}

	/* (non-Javadoc)
	 * @see java.util.List#addAll(int, java.util.Collection)
	 */
	public boolean addAll(int index, Collection c) {
		return addAll(index, c, true);
	}
	
	public boolean addAll(int index, Collection c, boolean updateDOM) {
		if (updateDOM && _element != null) {
			for (Iterator iter = c.iterator(); iter.hasNext();) {
				addElement(iter.next());
			}
		}
		return super.addAll(index, c);
	}
	
	private void addElement(Object obj) {
		Method getElementMethod;
		try {
			getElementMethod = obj.getClass().getMethod("getElement", null);
			Element child = (Element) getElementMethod.invoke(obj, null);
			//Utilities.appendChild(_element, child, _tagName);
			Utilities.appendChild(_inputObj, obj, _tagName);
		} catch (NoSuchMethodException e) {
			// ignore
		} catch (InvocationTargetException ite) {
			// ignore
		} catch (IllegalAccessException iae) {
			// ignore
		}
	}

}
