/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FontHelper.java,v 1.1 2005/03/30 08:26:49 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.util;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FontHelper.java,v 1.1 2005/03/30 08:26:49 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/



import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

/**
 * Helper class for getting font metrics and calculating string lengths.
 */
public class FontHelper {
	private Graphics2D g;
	private FontMetrics metrics;
	
	public FontHelper() {
		g = (new BufferedImage(1, 1, BufferedImage.TYPE_INT_RGB)).createGraphics();
		metrics = g.getFontMetrics();
	}
	
	public FontHelper(String fontName, int style, int size) {
		Font f = new Font(fontName, style, size);
		g.setFont(f);
		metrics = g.getFontMetrics();
	}
	
	public void setFont(Font font) {
		g.setFont(font);
		metrics = g.getFontMetrics();
	}
	
	public void setFontSize(float size) {
		Font font = g.getFont().deriveFont((float) size);
		g.setFont(font);
		metrics = g.getFontMetrics();
	}
	public double getStringWidth(String str) {
		return getStringWidth(str, 0, false);
	}

	public double getStringWidth(String str, double degrees) {
		return getStringWidth(str, degrees, false);	
	}
	
	public Dimension2D getStringBounds(String str, double degrees) {
		Rectangle2D rectangle = g.getFont().getStringBounds(str, g.getFontRenderContext());
		double radDegrees = degrees*Math.PI/180;
		double width = metrics.stringWidth(str) * 1.5;
		Dimension dim =  new Dimension((int)(width*Math.abs(Math.cos(radDegrees))+metrics.getHeight()*Math.abs(Math.sin(radDegrees))), (int)(width*Math.abs(Math.sin(radDegrees))+metrics.getHeight()*Math.abs(Math.cos(radDegrees))));
		return new Dimension((int)(width*Math.abs(Math.cos(radDegrees))+metrics.getHeight()*Math.abs(Math.sin(radDegrees))), (int)(width*Math.abs(Math.sin(radDegrees))+metrics.getHeight()*Math.abs(Math.cos(radDegrees))));
	}
	
	public double getStringWidth(String str, double degrees, boolean vertical) {
		Rectangle2D rectangle = g.getFont().getStringBounds(str, g.getFontRenderContext());
		double radDegrees = degrees*Math.PI/180;
		if (vertical) radDegrees += Math.PI/2;
		double width = metrics.stringWidth(str) * 1.5;		

		return width*Math.abs(Math.cos(radDegrees))+metrics.getHeight()*Math.abs(Math.sin(radDegrees));

	}

	public double getHeight() {
		return getHeight("", 0);
	}

	public double getHeight(String str, double degrees) {
 		 double radDegrees = degrees*Math.PI/180;
  		 double width = metrics.stringWidth(str)* 1.5;
		 return width*Math.abs(Math.sin(radDegrees))+metrics.getHeight()*Math.abs(Math.cos(radDegrees));
	}
	public double getHeight(String str, double degrees, int numOfLines) {
		 double radDegrees = degrees*Math.PI/180;
 		 double width = metrics.stringWidth(str)* 1.5;
		 return width*Math.abs(Math.sin(radDegrees))+(metrics.getHeight()*numOfLines)*Math.abs(Math.cos(radDegrees));
	}
	
//	public static void main(String[] args) {
//		 FontHelper helper = new FontHelper();
//		 helper.setFontSize(8);
//		 double len = helper.getStringWidth("aaaaaa");
//		 System.out.println(len);
//	}
}
