/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDRefList.java,v 1.2 2005/06/10 14:03:15 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDRefList.java,v 1.2 2005/06/10 14:03:15 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.w3c.dom.Element;

/**
 * IDRefList represents a list of ID references (IDREFS).
 * IDREFS is a list of object IDs separated by spaces. 
 * When an object is added to IDRefList, it will also be added to the IDREFS.
 */
public class IDRefList extends ArrayList {

	/**
     * 
     */
    private static final long serialVersionUID = 1L;
    private Element _element = null;
	private String _attributeName = null;
	
	public IDRefList(Element element, String attributeName) {
		_element = element;
		_attributeName = attributeName;
	}
	

	/* (non-Javadoc)
	 * @see java.util.List#add(int, java.lang.Object)
	 */
	public void add(int index, Object o) {
		add(index, o, true);
	}
	
	public void add(int index, Object o, boolean updateDOM) {
		if (updateDOM && _element != null && _attributeName != null) {
			addIDRef(o);
		}
		super.add(index, o);
	}

	/* (non-Javadoc)
	 * @see java.util.Collection#add(java.lang.Object)
	 */
	public boolean add(Object o) {
		return add(o, true);
	}
	
	public boolean add(Object o, boolean updateDOM) {
		if (updateDOM && _element != null && _attributeName != null) {
			addIDRef(o);
		}
		return super.add(o);
	}

	/* (non-Javadoc)
	 * @see java.util.Collection#addAll(java.util.Collection)
	 */
	public boolean addAll(Collection c) {
		return addAll(c, true);
	}
	
	public boolean addAll(Collection c, boolean updateDOM) {
		// TODO: This method can be optimized.
		if (updateDOM && _element != null) {
			for (Iterator iter = c.iterator(); iter.hasNext();) {
				addIDRef(iter.next());
			}
		}
		return super.addAll(c);
	}

	/* (non-Javadoc)
	 * @see java.util.List#addAll(int, java.util.Collection)
	 */
	public boolean addAll(int index, Collection c) {
		return addAll(index, c, true);
	}
	
	public boolean addAll(int index, Collection c, boolean updateDOM) {
		if (updateDOM && _element != null) {
			for (Iterator iter = c.iterator(); iter.hasNext();) {
				addIDRef(iter.next());
			}
		}
		return super.addAll(index, c);
	}
	
	private void addIDRef(Object obj) {
		Method getIdMethod;
		try {
			getIdMethod = obj.getClass().getMethod("getId", null);
			String newId = (String) getIdMethod.invoke(obj, null);
			StringBuffer idrefs = new StringBuffer();
			for (int i=0; i<size(); i++) {
				Object refObj = get(i);
				getIdMethod = refObj.getClass().getMethod("getId", null);
				String id = (String) getIdMethod.invoke(refObj, null);
				idrefs.append(id + " ");
			}
			idrefs.append(newId);
			_element.setAttribute(_attributeName, idrefs.toString());
		} catch (NoSuchMethodException e) {
			// ignore
		} catch (InvocationTargetException ite) {
			// ignore
		} catch (IllegalAccessException iae) {
			// ignore
		}
	}
}
