/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NLString.java,v 1.2 2008/12/12 22:22:11 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.util;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NLString.java,v 1.2 2008/12/12 22:22:11 jcayne Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/



import java.util.MissingResourceException;
import java.util.ResourceBundle;

import com.ibm.icu.util.ULocale;

public class NLString {
	
	private ResourceBundle bundle = null;
	
	public NLString() {
	}
	
	public NLString(String resourceBundle, ULocale locale) {
		bundle = ResourceBundle.getBundle(resourceBundle, locale.toLocale());
	}

	/**
	 * Gets the text of the given message key
	 * @param messageKey
	 * @return
	 */
	public String getString(String messageKey) {
		if (messageKey == null) {
			return null;
		}
		
		if (bundle != null) {
			if (messageKey.startsWith("%")) {
				if (messageKey.charAt(1) != '%') {
					try {
						String string = bundle.getString(messageKey.substring(1, messageKey.length()));
						if (string == null) {
							return messageKey;
						} else {
							return string;
						}
					} catch (MissingResourceException e) {
						return messageKey;
					}
				} else {
					// If the first and second characters are both '%', 
					// treat the string as a literal that starts with '%'
					return messageKey.substring(1, messageKey.length());
				}
			}
		}
		return messageKey;
	}
}
