/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGShapeIterator.java,v 1.1 2005/03/30 08:26:49 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.util;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGShapeIterator.java,v 1.1 2005/03/30 08:26:49 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


/**
 * This is the interface of a shape iterator that iterates through the shapes 
 * used in line charts and scatter charts. 
 */
public interface SVGShapeIterator {
	
	/**
	 * Gets the next shape ID. If a shape is explicitly assigend the the given
	 * data set, the specific shape will be returned. Otherwise, the next available
	 * shape in the palette will be returned. 
	 * @param dataSetId
	 * @return
	 */
	public String getNextShapeId(String dataSetId);
	
	/**
	 * Gets the width of the current shape
	 * @return
	 */
	public double getShapeWidth();
	
	/**
	 * Gets the height of the current shape
	 * @return
	 */
	public double getShapeHeight();
	
}
