/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ShapesDOMDocument.java,v 1.1 2005/03/30 08:26:49 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.util;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ShapesDOMDocument.java,v 1.1 2005/03/30 08:26:49 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.shapes.Shapes;
import org.eclipse.tptp.platform.report.chart.svg.internal.shapes.impl.ShapesImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;


/**
 * This class will provide a Chart object given a DOM representation
 * of the chart XML input.
 * 
 * Notes on error conditions:
 * - The value of an attribute that does not exist will be null.
 * - The value of a single node that does not list will be null.
 * - The value of a multiple node list that does not exist will be an empty list.
 * 
 *
 */
public class ShapesDOMDocument {
	
	protected Document _doc = null;
	
	private ShapesDOMDocument() {
		// Should not be called
		Utilities.assertion(false);
	}
	
	public ShapesDOMDocument(Document doc) {
		_doc = doc;
	}
	
	public Shapes getShapes() {
		Element element = (Element)_doc.getDocumentElement();
		return new ShapesImpl(element);
	}

}
