/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLLoader.java,v 1.3 2005/06/10 14:03:15 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.util;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLLoader.java,v 1.3 2005/06/10 14:03:15 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.io.File;
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
//import javax.xml.parsers.SAXParser;
//import javax.xml.parsers.SAXParserFactory;

import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**
 * 
 */
public class XMLLoader {
	
	static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
	private Document dom = null;
	private Exception exception = null;
	protected boolean validate = false;
	protected String schemaLocation;

	/**
	 * Inner class for handling XML validation errors
	 */
	class InputErrorHandler implements ErrorHandler {

		/**
		 * @see org.xml.sax.ErrorHandler#warning(org.xml.sax.SAXParseException)
		 */
		public void warning(SAXParseException e) throws SAXException {
			exception = e;
			// do nothing
		}

		/**
		 * @see org.xml.sax.ErrorHandler#error(org.xml.sax.SAXParseException)
		 */
		public void error(SAXParseException e) throws SAXException {
			exception = e;
			throw e;
		}

		/**
		 * @see org.xml.sax.ErrorHandler#fatalError(org.xml.sax.SAXParseException)
		 */
		public void fatalError(SAXParseException e) throws SAXException {
			exception = e;
			throw e;
		}

	}
	
	/**
	 * Constructor - In order to use valid XML, the schema location must be set before
	 * validate() is called
	 */
	public XMLLoader() {
	}
	
	/**
	 * Constructor
	 * @param reader Reader of the XML document
	 * @param schemaLocation Location of the schema
	 */
	public XMLLoader(String schemaLocation) {
		this.schemaLocation = schemaLocation;
	}

	/**
	 * Set XML validation flag
	 * @param validating true if XML should be validated, false otherwise.
	 */
	public void setValidating(boolean validating) {
		validate = validating;
	}

	/**
	 * validate XML 
	 * @param inputSource
	 * @return true if XML is valid, false otherwise.
	 */
	public boolean load(InputSource inputSource) {
		
		DocumentBuilderFactory factory = DocumentBuilderFactory
		.newInstance();
		if (validate)
			factory.setAttribute(JAXP_SCHEMA_SOURCE, new File(schemaLocation));

			try {
				DocumentBuilder builder = factory.newDocumentBuilder();

				dom = builder.parse(inputSource);
			} catch (ParserConfigurationException e) {
				return false;
			} catch (SAXException e) {
				return false;
			} catch (IOException e) {
				return false;
			}
			
		
		return true;
	}
	
	/**
	 * Gets DOM tree of the XML document
	 * @return dom tree after validate() is called, returns null validate() has not been called
	 */
	public Document getDOM() {
		return dom;
	}
	
	/**
	 * Gets the exception if an error has occurred during validation.
	 * @return exception if one exists, null if no error occurred.
	 */
	public Exception getException() {
		return exception;
	}
}
