/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DAbstractParagraph.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.core.internal;

/**
 * Provides an abstract class for all another DItemContainer which 
 * have alignment property
 * 
 * @see IDAlignment
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public abstract class DAbstractParagraph extends DItemContainer implements IDAlignment {

	/** hold alignment applyied on paragraph */
	private int alignment;
	
	/**
	 * Constructs a new Abstract Paragraph with an initial value for the property _align.
	 * @param _align alignment property, combined mask of IDAligment.
	 */
	public DAbstractParagraph(int _align) 
	{
		alignment = _align;    
	}
	
	/**
	 * Creates a Abstract Paragraph with DEFAUL_ALIGN alignment.
	 */
	public DAbstractParagraph() 
	{
		alignment = DEFAULT_ALIGN;
	}
	
	/**
	 * Access method for the align property.
	 * 
	 * @return   the current value of the align property
	 */
	public int getAlignment() 
	{
		return alignment;    
	}

	/**
	 * Returns the current alignment reduced to given mask.
	 */
	public int getAlignment( int _alignment_mask )   
	{
		return alignment & _alignment_mask;     
	}
	
	/**
	 * Sets the value of the align property.
	 * 
	 * @param aAlignment the new value of the align property
	 */
	public void setAlignment(int aAlignment) 
	{
		alignment = aAlignment;    
	}
	
	/**
	 * Add alignments to the current value of alignment.
	 * 
	 * @param aAlignment the alignment to add.
	 */
	public void addAlignment(int aAlignment ) 
	{
		alignment |= aAlignment;    
	}

	/**
	 * remove alignments to the current value of alignment.
	 * 
	 * @param aAlignment the alignment to remove.
	 */
	public void removeAlignment(int aAlignment ) 
	{
		alignment &= ~aAlignment;    
	}

	/**
	 * Returns true is alignment contains the given mask.
	 * 
	 * @param mask the mask.
	 */
	public boolean haveAlignment( int mask )
	{
		return (alignment & mask )==mask ;
	}
	
	/**
	 * Returns true is alignment contains one of alignment in the given mask.
	 * 
	 * @param mask the mask.
	 */
	public boolean haveOneOfAlignment( int mask )
	{
		return (alignment & mask )!=0 ;
	}
	


}
