/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DAxis.java,v 1.5 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;


/**
 * Axis is used to store coordinates in point. Axis are child or <i>DGraphic</i>.
 * For example two dimensional graphic displaying XY curve, contains two
 * axis (one for x, one for y).
 * Point coordinate can't be defined without axis, that's why even for simple
 * graphics like histograms, an axis is required. 
 * Axis is named: expected to be unic for all axis of a graphic (name means identifier).
 * Axis have a title and a unit that can be displayed to user.
 * Axis can use linear or logarythmic scale.
 * Axis can use float (or integer) values or java.util.Date values.
 * Axis contains properties like min/max values (after a document update), or
 * steps (line,unit,dot) for display purpose.
 * For a <b>logarythmic</b> scaled axis steps must be in ]0..10[ and configure which line (unit,dot) 
 * is displayed for this decade 1..10, others are known by multiplying (dividing) by 10.
 * For example
 * a step_unit of 5 means the followings units text will be used 1,5,10,50,100,500,1000,....
 * For a <b>date</b> axis steps can be <i>long</i> (delay in milliseconds), or an instance of
 * <i>CalendarField</i> to express usual steps like "every 6 month".
 * @see DPoint 
 * @see DCoord 
 * @see DCurve 
 * @see DGraphic
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class DAxis extends DItemContainer 
{
   
   /**
    * property key, min. coordinate value asked for axis. As is an prefered value, graphic render
    * might choose an other value (for example the actual minimum coordinates of points in graphic).
    * (see P_MIN).
    */
   public static final String P_MIN_HINT = "P_MIN_HINT.DAxis.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key, max. coordinate value asked for axis. As is an prefered value, graphic render
    * might choose an other value (for example the actual minimum coordinates of points in graphic).
    * (see P_MAX).
    */
   public static final String P_MAX_HINT = "P_MAX_HINT.DAxis.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key, an object value asking to display lines each STEP_LINE value.
    * Axis using <b>number</b> (float,double) values, set this property with a number.
    * Axis using <b>date</b> values, set this property with a long to express a delay in milliseconds,
    * or with a CalendarField to set simple date steps, for example: "new CalendarField(Calendar.MONTH,6)"
    * to set a step every 6 month.
    */
   public static final String P_STEP_LINE = "P_STEP_LINE.DAxis.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key, an object asking to display units each STEP_UNIT value (might be a number).
    * (see P_STEP_LINE)
    */
   public static final String P_STEP_UNIT = "P_STEP_UNIT.DAxis.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key, a value asking to display dots each STEP_DOT value
    * (see P_STEP_LINE)
    */
   public static final String P_STEP_DOT = "P_STEP_DOT.DAxis.core.jscrib"; //$NON-NLS-1$

   /**
    * property key, after document update, store min. value value on this axis.
    * If set graphic render must use this value.
    * (see P_MIN_HINT)
    */
   public static final String P_MIN = "P_MIN.DAxis.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key, after document update, store max coordinate on axis.
    * If set graphic render must use this value.
    * (see P_MAX_HINT)
    */
   public static final String P_MAX = "P_MAX.DAxis.core.jscrib"; //$NON-NLS-1$

   /**
    * property key for a Boolean object, true if title must be displayed, false to do not.
    * If property isn't set (default), the axis's title is displayed.
    */
   public static final String P_SHOW_TITLE = "P_SHOW_TITLE.DAxis.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a IDColor instance that configure color used to render STEP_LINE
    * in a different color than axis's style foreground.
    */
   public static final String P_LINE_COLOR = "P_LINE_COLOR.DAxis.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a Class that set data type for this axis, float by default.
    * For a date axis set this property with "Date.class"
    */   
   public static final String P_DATA_CLASS = "P_DATA_CLASS.DAxis.core.jscrib"; //$NON-NLS-1$
   /**
    * property key for a IScaleProvider you can set to instanciate particular IScale.
    * This is mandatory for unhandled P_DATA_CLASS you set (ie: not for java.util.Date, 
    * or if !DAxis.useNumbers().
    */
   public static final String P_DATA_SCALE_PROVIDER="P_DATA_SCALE_PROVIDER.DAxis.core.jscrib"; //$NON-NLS-1$
   /**
    * property key for a suitable com.ibm.icu.text.Format class for P_DATA_CLASS.
    * For example: DAxis can use com.ibm.icu.text.DecimalFormat if it's using decimal values,
    *  or for a Date value use com.ibm.icu.text.DateFormat.
    * By default, if axis use number a DecimalFormat is used, and if axis use Date
    * a SimpleDateFormat is used.
    */
   public static final String P_UNIT_FORMAT = "P_UNIT_FORMAT.DAxis.core.jscrib"; //$NON-NLS-1$
   /**
    * property key for an IDAlignment object used only to align label on T_HISTOGRAM
    * and T_HISTOGRAM_IM graphics. 
    * By default alignment is centered horizontal.
    * @see DPoint to learn how to set labels. 
    */
   public static final String P_LABEL_ALIGNMENT = "P_LABEL_ALIGNMENT.DAxis.core.jscrib"; //$NON-NLS-1$
   /**
    * property key for an IDAlignment object used only to render P_STEP_UNIT for
    * T_HISTORS graphics. Value might be TOP,LEFT,RIGHT,BOTTOM or Or'ed combination of them.<br>
    * LEFT means units are ROTCCW90, and RIGHT means units are ROTCW90.<br>  
    * By default alignment is the fourth.
    */
   public static final String P_HISTORS_UNIT = "P_HISTORS_UNIT.DAxis.core.jscrib"; //$NON-NLS-1$
   /**
    * property key for a Boolean object used only to render P_STEP_UNIT for
    * T_HISTORS graphics.<br>
    * false means units are rendered transparent ( circle pass through unit's text).<br>
    * true means units are rendered opaque using axis applyed style background color.<br>  
    * By default this property is false.
    */
   public static final String P_HISTORS_UNIT_OPAQUE = "P_HISTORS_UNIT_OPAQUE.DAxis.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a Boolean object used do draw or not the axis
    * By default this property is true.
    * Only activated for the SVG generation
    */
   public static final String P_SHOW = "P_SHOW.DAxis.core.jscrib"; //$NON-NLS-1$
   /**
    * property key for a string which defines the rotation angle for the axis label. 
    * By default the value is DAxis.S_ZERO_DEGREE
    * The others values could be DAxis.S_PLUS_NINTY_DEGREE and DAxis.S_MINUS_NINTY_DEGREE
    * Only activated for the SVG generation 
    */
   public static final String P_LABEL_ROTATION = "P_LABEL_ROTATION.DAxis.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a boolean to show or not the tick on the axis for the major unit. 
    * By default the value is true
    * Only activated for the SVG generation 
    */
   public static final String P_MAJUNIT_SHOWTICK = "P_MAJUNIT_SHOW_TICK.DAxis.core.jscrib"; //$NON-NLS-1$
   /**
    * property key for a boolean to show or not the grid line for the major unit. 
    * By default the value is true
    * Only activated for the SVG generation 
    */
   public static final String P_MAJUNIT_SHOWGRID = "P_MAJUNIT_SHOWGRID.DAxis.core.jscrib"; //$NON-NLS-1$
   /**
    * property key for an object compatible with the value contained in the P_DATA_CLASS 
    * property. The object can be Double, Date and String.
    * By default the value is 0.0.
    * Only activated for the SVG generation 
    */
   public static final String P_MAJUNIT_VALUE = "P_MAJUNIT_VALUE.DAxis.core.jscrib"; //$NON-NLS-1$
   /**
    * property key for a boolean to show or not the tick on the axis for the minor unit. 
    * By default the value is true
    * Only activated for the SVG generation 
    */
   public static final String P_MINUNIT_SHOWTICK = "P_MINUNIT_SHOW_TICK.DAxis.core.jscrib"; //$NON-NLS-1$
   /**
     * property key for a boolean to show or not the grid line for the minor unit. 
    * By default the value is true
    * Only activated for the SVG generation 
    */
   public static final String P_MINUNIT_SHOWGRID = "P_MINUNIT_SHOWGRID.DAxis.core.jscrib"; //$NON-NLS-1$
   /**
     * property key for an object compatible with the value contained in the P_DATA_CLASS 
    * property. The object can be Double, Date and String.
    * By default the value is 0.0
    * Only activated for the SVG generation 
    */
   public static final String P_MINUNIT_VALUE = "P_MINUNIT_VALUE.DAxis.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a string object which defines the pattern used to draw
    * the axis label 
    * By default the value is null
    * Only activated for the SVG generation 
    */
   public static final String P_LABEL_FORMAT  = "P_LABEL_FORMAT.DAxis.core.jscrib"; //$NON-NLS-1$
   /**
    * property key for a string object which defines the label type (number, date)
    * the axis label 
    * By default the value is null
    * Only activated for the SVG generation 
    */
   public static final String P_LABEL_FORMATTYPE = "P_LABEL_FORMATTYPE.DAxis.core.jscrib"; //$NON-NLS-1$
 
   /** Define a linear scale type for axis, this is the default. */
   public static final String S_LIN="S_LIN.DAxis.core.jscrib"; //$NON-NLS-1$
   /** Define a logarythmic scale (for numbers axis only).*/
   public static final String S_LOG="S_LOG.DAxis.core.jscrib"; //$NON-NLS-1$
   
   /** Define a zero degree rotation for the label, this is the default. */
   public static final String S_ZERO_DEGREE="zeroDegree"; //$NON-NLS-1$
   /** Define a positive 90 degree rotation for the label. */
   public static final String S_PLUS_NINTY_DEGREE="plusNinetyDegrees"; //$NON-NLS-1$ 
   /** Define a negative 90 degree rotation for the label. */
   public static final String S_MINUS_NINTY_DEGREE="minusNinetyDegrees"; //$NON-NLS-1$
   
   
   /** Property store. */
   private DPropertyStore properties_ = new DPropertyStore();
   /** name (i.e. id of the axis) */
   private String name_;
   /** title of the axis */
   private String title_;
   /** the unit of the axis (display purpose only) */
   private String unit_ ;
   /** define the scale type this axis use, by default a linear scale */
   private String scale_;
   /** axis tooltip */
   private String tooltip_;
   
   /**
    * Create an axis with a name, an unit and a title.
    * @param _name name of the axis (ie axis identifier)
    * @param _unit unit for axis
    * @param _title title for axis
    */
   public DAxis(String _name, String _unit, String _title) 
   {
     setName(_name);
     unit_=_unit;
     title_=_title;    
     scale_=S_LIN;
   }
   
   /**
    * Create an axis without unit and title. Name is required.
    * @param _name
    */
   public DAxis(String _name) 
   {    
     scale_=S_LIN;
     setName(_name);
   }
   
   /** 
    * Returns property store
    */
   public DPropertyStore getProperties() { return properties_; }

   /**
    * @return  the name of the axis
     */
   public String getName() 
   { 
     return name_;    
   }
   
   /**
    * Change the name of the axis. Remember name is expected to be unic in a graphic.
    * @param _name new axis name.
    */
   public void setName(String _name) 
   {
     name_ = _name==null ? "unamed" : _name ;    
   }
   
   /**
    * @return  the axis title, can be null.
    */
   public String getTitle() 
   {
     return title_;    
   }
   
   /**
    * Change axis title.
    * @param _title new axis title.
    */
   public void setTitle(String _title) 
   {
      title_ = _title;    
   }
   
   /**
    * @return the unit of axis, can be null.
    */
   public String getUnit() 
   {
     return unit_;    
   }
   
   /**
    * Change unit of axis.
    * @param _unit new unit of axis.
   */
   public void setUnit(String _unit) 
   {
      unit_ = _unit;    
   }
   
   /**
    * Replace current property store in axis.
    * @param store the new property store.
    */
   public void setProperties(DPropertyStore store)
   {
	 properties_ = store;
   }
   
   /**
    * @return current scale type this axis use.
    */
   public String getScaleType() { return scale_; }
   
   /**
    * Changes value of scale type used by this axis.
    */
   public void  setScaleType( String _scale )
   {
     scale_=_scale;
   }
   
   /**
    * @return true if the specified scale type is the current in this axis.
    */
   public boolean isScaleType( String _scale )
   {
     if( _scale == scale_ ) return true ;
     if( scale_!=null && scale_.equals( _scale )) return true;
     return _scale.equals( scale_ );
   }
   
   /**
    * @return true if this axis use number as data class (like double, float).
    * @see #P_DATA_CLASS
    */
   public boolean useNumbers()
   {
     if( properties_==null ) return true;
     Class v = (Class)properties_.get(P_DATA_CLASS);
     if( v==null ) return true;
     return Number.class.isAssignableFrom( v );
//     if( v == Float.class ) return true;
//VFloat => ?     
//??     if( v == Integer.class ) return true;
// ....
//     return false;
   }
   
   /**
    * @return true is this axis use given class for values. This is known looking P_DATA_CLASS
    * @see #useNumbers
    */
   public boolean isDataClass( Class _class )
   {
     if( properties_==null ) return Number.class.isAssignableFrom( _class );
     Class v = (Class)properties_.get(P_DATA_CLASS);
     return _class==v;
   }
   
   
   /** @return the text tooltip for the axis */
   public String getTooltip() {
      return tooltip_;
   }

   /** Sets the text tooltip for the axis */
   public void setTooltip(String tooltip) {
       this.tooltip_ = tooltip;
   }
}
