/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DBorder.java,v 1.3 2008/05/23 14:11:48 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.core.internal;


/**
 * Apply a border to children items.<br>
 * Border can ave the following settings:<BR>
 * - a line type (see L_xxxx constants)<BR>
 * - a shadow type (see S_xxx constants)<BR>
 * - a shadow depth.<BR>
 * - a shadow color.<BR>
 * - a margin.<BR>
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DBorder extends DItemContainer implements IDParagraphItem
{
  /** Shadow type is None, ie no shadow */
  public static final int S_NONE=0;
  /** Shadow type is Solid */
  public static final int S_SOLID=1;
  /** Shadow type is Gradient */
  public static final int S_GRADIENT=2;
  /** Shadow type is an Halod (gradient) around children */
  public static final int S_HALO=3;
  
  /** no line around children item */
  public static final int L_NONE=0;
  /** simple line around children item */
  public static final int L_SIMPLE=0x1;
  /** two-pixel width line around children item */
  public static final int L_BOLD=0x3;
  /** three-pixel width line around children item */
  public static final int L_HEAVY=0x7;
  /** double line around children item */
  public static final int L_DOUBLE=0x5;
  /** three lines around children item */
  public static final int L_TRIPLE=0x15;
  /** a bold and a simple line around children item */
  public static final int L_BOLD_SIMPLE=0xB;
  /** a simple and a bold line around children item */
  public static final int L_SIMPLE_BOLD=0xD;
  
  protected int shadow_type_;
  protected int shadow_depth_;
  protected IDColor shadow_color_;
  protected int line_type_;
  protected int margin_;
  
  /** Create a default border (solid shadow, depth=8), L_SIMPLE line type and maring=3 */
  public DBorder()
  {    
    shadow_type_= S_SOLID;
    shadow_depth_ = 8;
    line_type_ = L_SIMPLE;
    margin_=3;
  }
  
  /** Create a border with a line type, shadow is L_NONE */
  public DBorder( int line_type )
  {
    shadow_type_ = L_NONE;
    line_type_ = line_type;
    shadow_depth_ = 8;
    margin_=3;
  }
  /** Create a border with a shadow_type and a shadow_depth, line type is L_SIMPLE */
  public DBorder(  int shadow_type, int shadow_depth )
  {
    shadow_type_ = shadow_type;
    shadow_depth_ = Math.max(0,shadow_depth);
    line_type_ = L_SIMPLE;
    margin_=3;
  }
  /** Create a border with a shadow_type, a shadow_depth and a line type */
  public DBorder( int shadow_type, int shadow_depth, int line_type )
  {
    shadow_type_ = shadow_type;
    shadow_depth_ = Math.max(0,shadow_depth);
    line_type_ = line_type;
    margin_=3;
  }
  
  /** Create a border copying all parameter from given one (taken as a "model") */
  public DBorder( DBorder model )
  {
    setBorder( model );
  }
  
  /** @return current shadow type */
  public int getShadowType() { return shadow_type_; }
  /** @return shadow depth (in pixels)*/
  public int getShadowDepth() { return shadow_depth_; }
  /** @return current shadow color */
  public IDColor getShadowColor() { return  shadow_color_; }
  /** @return current line type */
  public int getLineType() { return line_type_; }
  /** @return current margin (in pixels)  */
  public int getMargin() { return margin_; }
  
  /** @return true is this border shadow type if the one given in parameter */
  public boolean isShadowType( int _type ) { return shadow_type_==_type; }
  
  /** change shadow type, use one constant from S_xxxx set */
  public void setShadowType( int _type ) { shadow_type_=_type; }
  /** Change shadow depth (in pixels) */
  public void setShadowDepth( int _depth ) { shadow_depth_=Math.max(0,_depth); }
  /** Change shadow color */
  public void setShadowColor( IDColor c ) { shadow_color_=c; } 
  /** Change line type, use one constant from L_xxx set */
  public void setLineType( int _type ) { line_type_=_type; }
  /** Change inside margin from line of border to contained items (in pixels) */
  public void setMargin( int margin ) { margin_ = Math.max(0,margin); }
  
  /** Change all of this border parameter copying them from given border (taken as a "model") */
  public void setBorder( DBorder model )
  {
    shadow_type_ = model.shadow_type_;
    shadow_depth_ = model.shadow_depth_;
    shadow_color_ = model.shadow_color_;
    line_type_ = model.line_type_;
    margin_ =model.margin_;
  }
  
  /** @return String conversion from a S_xxxx constant */
  public static String StrShadowType( int st )
  {
    switch( st )
    {
     case S_NONE: return "NONE"; //$NON-NLS-1$
     case S_SOLID: return "SOLID"; //$NON-NLS-1$
     case S_GRADIENT: return "GRADIENT"; //$NON-NLS-1$
     case S_HALO: return "HALO"; //$NON-NLS-1$
     default: return "UNKNOWN"; //$NON-NLS-1$
    }
  }
  
  /** @return a S_xxx constant value from given String (one of returned by StrShadowType for example) */
  public static int ToShadowType( String str )
  {
    if( str==null ) return S_NONE;
    if( str.equals("NONE") ) return S_NONE; //$NON-NLS-1$
    if( str.equals("SOLID") ) return S_SOLID; //$NON-NLS-1$
    if( str.equals("GRADIENT") ) return S_GRADIENT; //$NON-NLS-1$
    if( str.equals("HALO") ) return S_HALO; //$NON-NLS-1$
    return S_NONE;
  }
  
  /** @return String conversion of a L_xxx constant, "NONE" by default */
  public static String StrLineType( int lt )
  {
    switch( lt )
    {
    default:
    case L_NONE: return "NONE"; //$NON-NLS-1$
    case  L_SIMPLE: return "SIMPLE"; //$NON-NLS-1$
    case L_BOLD: return "BOLD"; //$NON-NLS-1$
    case L_HEAVY: return "HEAVY"; //$NON-NLS-1$
    case L_DOUBLE: return "DOUBLE"; //$NON-NLS-1$
    case L_TRIPLE: return "TRIPLE"; //$NON-NLS-1$
    case L_BOLD_SIMPLE: return "BOLD_SIMPLE"; //$NON-NLS-1$
    case L_SIMPLE_BOLD: return "SIMPLE_BOLD"; //$NON-NLS-1$
    }
  }
  
  /** @return a L_xxx value from given String (one of returned by StrLineType() for example, or L_NONE */
  public static int ToLineType( String str )
  {
    if( str==null ) return L_NONE;
    if( str.equals("NONE") ) return L_NONE; //$NON-NLS-1$
    if( str.equals("SIMPLE") ) return L_SIMPLE; //$NON-NLS-1$
    if( str.equals("BOLD") ) return L_BOLD; //$NON-NLS-1$
    if( str.equals("HEAVY") ) return L_HEAVY; //$NON-NLS-1$
    if( str.equals("DOUBLE") ) return L_DOUBLE; //$NON-NLS-1$
    if( str.equals("TRIPLE") ) return L_TRIPLE; //$NON-NLS-1$
    if( str.equals("BOLD_SIMPLE") ) return L_BOLD_SIMPLE; //$NON-NLS-1$
    if( str.equals("SIMPLE_BOLD") ) return L_SIMPLE_BOLD; //$NON-NLS-1$
    return L_NONE;
  }
}
