/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DCellText.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;


/**
 * Optimisation of a DCell: The difference is that a DCellText only accept a single text String.
 * 
 * @see DCell
 * @see DText
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class DCellText extends DCell implements IDTextualItem
{
   private String text = null;
   
   /**
    * Creates a cell text with colspan, rowspan and alignment.
    *
    * @param t is the text 
    * @param cspan is the number of column that the cell can occupate to the right.
    * @param rspan is the number of line that the cell can occupate to the bottom.
    * @param align is the global alignment for the cell.
    * 
    * @see IDAlignment
    */
   public DCellText(String t, int cspan, int rspan, int align) 
   {
   	super(cspan, rspan, align);
    text = t;
   }
   
   /**
    * Creates a cell text with colspan, rowspan and default alignment.
    *
    * @param t is the text 
    * @param cspan is the number of column that the cell can occupate to the right.
    * @param rspan is the number of line that the cell can occupate to the bottom.
    * 
    */
   public DCellText(String t, int cspan, int rspan) 
   {
   	super(cspan, rspan);
   	text = t;
   }
   
   /**
    * Creates a cell text with aligment.
    *
    * @param t is the text 
    * @param align is the global alignment for the cell.
    * 
    * @see IDAlignment
    */
   public DCellText(String t, int align) 
   {
   	 super(align);
   	 text = t;
   }
   
   
   
   /**
    * Creates a DCellText.
    * The text string is passed in argument. 
    */
   public DCellText(String t) 
   {
     text = t;    
   }
   
   /**
    * Creates a DCellText with a null text.
    */
   public DCellText() 
   {}
   
   /**
    * Access method for the text property.
    * 
    * @return   the current value of the text property
    */
   public String getText() 
   {
      return text;    
   }
   
   /**
    * Sets the value of the text property.
    * 
    * @param aText the new value of the text property
    */
   public void setText(String aText) 
   {
      text = aText;    
   }
   
}
