/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DChildrenController.java,v 1.3 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 12 nov. 2003
 *
 */
package org.eclipse.tptp.platform.report.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List ;
import java.util.Iterator ;

/**
 * This class contains rules to check insertion of a IDItem child in a item.
 * Call one of acceptChild() method to perfrom check.
 * By default all rules for core IDItem are checked, if you want to add a
 * rule, call installChildRule() or installChildrenRule()
 * (for example if you create a new extended IDItem).
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DChildrenController
{
  protected static HashMap rules = new HashMap();
  
  /**
   * Add a rule to allow the insertion of children in given parent class.
   * @param _parent Class of parent
   * @param _children array of Class object, classes of allowed children.
   */
  public static void installChildrenRule( Class _parent, Class _children[] )
  {
    List rule = (List)rules.get( _parent );
    if( rule == null )
    {
      rule = new ArrayList( _children.length );
      rules.put( _parent, rule );
    }
    for( int i=0; i<_children.length; ++i )
    {
      rule.add( _children[i] );
    }
  }
  
  /**
   * Add a rule to allow the insertion of a child in given parent class.
   * @param _parent Class of parent
   * @param _child  Class of allowed child.
   */
  public static void installChildRule( Class _parent, Class _child )
  {
    List rule = (List)rules.get( _parent );
    if( rule == null )
    {
      rule = new ArrayList();
      rule.add( _child );
      rules.put( _parent, rule );
    }
    else
    {
      rule.add( _child );
    }
  }
  
  /** 
   * Remove a rule for given child in a _parent.
   */
  public static boolean removeChildClass( Class _parent, Class _child )
  {
    List rule = (List)rules.get( _parent );
    if( rule != null )
    {
      rule.remove( _child );
      if( rule.size()==0 )
      {
        rules.remove( _parent );
      }
      return true;
    }
    return false;
  }
  
  /**
   * Return true if _child is allowed to be a child  of _parent.
   * @return true if _child can be a child of _parent.
   * @param _parent Parent instance.
   * @param _child Child instance to check.
   */
  public static boolean acceptChild( IDItem _parent, IDItem _child )
  {
    return acceptChild(_parent.getClass(), _child);
  }

  /**
   * Return true if _child class is allowed to be a child of _paren's classt.
   * @return true if _child can be a child of _parent.
   * @param _parent Parent class.
   * @param _child Child class to check.
   */
  public static boolean acceptChild( Class _parent, IDItem _child )
  {
    if (_child==null) return false;
    
    //handle that _parent is a sub class of one of rules
    for( Class parent=_parent; parent!=null; parent=parent.getSuperclass() )
    {
      List rule = (List)rules.get( parent ) ;
      if (rule != null)
      {
        Iterator it = rule.iterator();
        for( ; it.hasNext(); )
        {
           Object o = it.next();
           if( ((Class)o).isInstance( _child ) )
           { 
              return true;
           }
        }
      }
    }
    
System.err.println("DChildrenController: [FAILED] acceptChild( "+_parent.getName()+", "+_child.getClass().getName()+")");    
    return false;
  }
  
  /** Install Core rules */
  static
  {
    installChildRule( DParagraph.class, IDParagraphItem.class );
    installChildRule( DLink.class, IDBasicItem.class );
    installChildRule( DTable.class, DRow.class );
    installChildRule( DRow.class, DCell.class );
    installChildRule( DCell.class, IDParagraphItem.class );
    installChildrenRule( DGraphic.class, new Class[]{ DGraphic.class, DCurve.class, DAxis.class, DEvent.class, DAccessibilityTitle.class, DAccessibilityDesc.class,
                         DI18N.class, DPreferences.class, DTimeStamp.class, DInclude.class,
                         DPalettes.class, DShapes.class} );
    installChildrenRule( DPoint.class, new Class[]{ IDCoord.class, DText.class, DEvent.class, DAccessibilityTitle.class, DAccessibilityDesc.class } );
    installChildrenRule( DCurve.class, new Class[]{DPoint.class, DEvent.class, DAccessibilityTitle.class, DAccessibilityDesc.class} );
    installChildrenRule( DAxis.class, new Class[]{ DCategory.class, DEvent.class, 
                         DAccessibilityTitle.class, DAccessibilityDesc.class,
                         DMarkerLine.class, DMarkerRegion.class} );
    installChildrenRule( DCategory.class, new Class[]{ DEvent.class, DAccessibilityTitle.class, DAccessibilityDesc.class} );
    installChildRule( DSection.class, IDParagraphItem.class );
    installChildrenRule( DDocument.class, new Class[]{ IDParagraphItem.class, DSection.class } );
    installChildRule( DFooter.class, IDParagraphItem.class );
    installChildRule( DHeader.class, IDParagraphItem.class );
    installChildRule( DIndexEntry.class, IDParagraphItem.class );
    installChildrenRule( DList.class, new Class[]{ DParagraph.class, DLink.class, IDBasicItem.class } );
    installChildrenRule( DPopup.class, new Class[]{ IDParagraphItem.class, IDBasicItem.class } );
    installChildRule( DTitle.class, IDBasicItem.class ); 
    installChildRule( IDParagraphItem.class, DFolder.class );
    installChildRule( DDocument.class, DFolder.class );
    installChildRule( DSection.class, DFolder.class );
    installChildRule( DCell.class, DFolder.class );
    installChildRule( DParagraph.class, DFolder.class );
    installChildRule( DFolder.class, IDParagraphItem.class );
    installChildRule( DFolder.class, DFolder.class );
    DChildrenController.installChildRule( IDParagraphItem.class, DBorder.class );
    DChildrenController.installChildRule( DParagraph.class, DBorder.class );
    DChildrenController.installChildRule( DCell.class, DBorder.class );
    DChildrenController.installChildRule( DBorder.class, IDParagraphItem.class );
    DChildrenController.installChildRule( DBorder.class, DBorder.class );
  }
}
