/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DColorRegistry.java,v 1.2 2008/05/23 14:11:48 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * A DColorRegistry is a registry collecting IDColor objects. 
 * A DColorRegistry stores only one instance of IDColor if two IDColor are equals.
 * Before to store a new IDColor the registry checks if the IDColor doesn't exist in the
 * registry by calling the method <b>contains</b>.
 *
 * @see IDColor
 * @see #contains
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DColorRegistry implements IDRegistry
{
   private ArrayList colors;
   
   /**
    * Creates an empty DColorRegistry.
    */
   public DColorRegistry() 
   {
     colors = new ArrayList();
   }
   
   /**
    * Clears the Registry of keys.
     */
   public void clear() 
   {
      colors.clear();    
   }
   
   /**
    * Returns true if the color is already stored in the registry. This method uses the equal
    * method of the IDColor object to compare between them. 
    * 
    * @see #equals
    */
   public boolean contains( IDColor color )
   {
     //compare object in strict way to do trust equals()
     for( Iterator it=colors.iterator(); it.hasNext(); )
     {
       if( it.next() == color ) return true;
     }
     return false;
   }
   
   /**
    * Put the color in the registry only if color isn't already stored.
    */
   public void putColor( IDColor c ) 
   {
     if( c==null ) return ;
     if( contains(c) ) return ; //already stored.
     colors.add( c );
   }
   
   /**
    * Remove the color if stored in registry.
    */
   public boolean remove( IDColor c )
   {
     return colors.remove( c );
   }
   
   /**
    * Returns an iterator to access to all colors. 
    */
   public Iterator iterator()
   {
     return colors.iterator();
   }

   /** @return true if registry is empty, false if not */
   public boolean isEmpty()
   {
     return colors.isEmpty();
   }
}
