/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DCoord.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;

import org.eclipse.tptp.platform.report.tools.internal.VDouble;
import org.eclipse.tptp.platform.report.tools.internal.VNumber;


/**
 * A double coordinate on an axis, designed to be a child of a DPoint.
 * As using double, all java number primitive types are covered (and can be stored
 * here ). But this is the worst choice in term of memory consumming, especially
 * if you have to store only a byte or integer ...
 * In this case this is a good idea to create your own IDCoord implementation
 * (might extending DCoordAbstract) to store only an integer.
 * 
 * @see DPoint
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DCoord extends DCoordAbstract
{
   private double value_;
   
   /**
    * Create coordinate v on axis a
    * @param a axis of the coordinate
    * @param v value of coordinate
    */
   public DCoord(DAxis a, double v) 
   {
     super( a );
     value_ = v;    
   }
   
   /**
    * Create unusable unknown coordinate on an inexistent axis.
    * Becarefull using this constructor, you mus provide axis/value
    * calling setAxis(), setValue().
    */
   public DCoord() 
   {
     value_=0.0;    
   }
   
   /**
    * @return  value of the coordinate.
    */
   public double getValue() 
   {
     return value_;    
   }
   
   /**
    * @return current coordinate value using VFloat instance. If parameter is an instance of class VFloat,
    * use this object rather than create a new VFloat instance.
    *
    * @see org.eclipse.tptp.platform.report.tools.internal.VFloat
    * @see #getValue
    */
   public Object getValue( Object _p )
   {
     if( _p instanceof VNumber ) return ((VNumber)_p).setValue( value_);
     return new VDouble(value_);
   }
   
   /**
    * Change value in coordinate if parameter is an instance of java.lang.Number.
    * Otherwise do nothing.
    */
   public void setValue( Object _value )
   {
     if( _value instanceof Number ) value_ = ((Number)_value).floatValue();
   }

   
   /**
    * Change the value of the coordinate.
    * @param _value new value of the coordinate.
    */
   public void setValue(double _value) 
   {
      value_ = _value;    
   }

}
