/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DCoordAbstract.java,v 1.2 2008/05/23 14:11:48 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;


/**
 * Abstract DCoord. Doesn't define any implementation choice to store value.
 * Use IDItem to hold nor IDItem children nor IDStyle in this object (consume less memory).
 * 
 * @see DAxis 
 * @see DPoint
 * @see DCoord
 * @see DCoordObject
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public abstract class DCoordAbstract implements IDCoord, IDItem 
{
//TODO a voir ..
  static {
    DChildrenController.installChildRule( DPoint.class, DCoordAbstract.class );  
  }
   /** coordinate applied on this axis  */
   private DAxis axis_;
   /** next item */
   private IDItem next_;
   /** parent item */
   private IDItem parent_;
   
   /**
    * Create coordinate on an axis.
    * @param a axis of the coordinate
    */
   public DCoordAbstract(DAxis a) 
   {
     axis_ = a;
   }
   
   /**
    * Create unusable unknown coordinate on an inexistent axis.
    * Becarefull using this constructor, you must provide axis/value
    * calling setAxis(), setValue().
    */
   public DCoordAbstract() 
   {    
   }
   
   /**
    * @return axis of the coordinate.
    */
   public DAxis getAxis() 
   {
      return axis_;    
   }
   
   /**
    * Change axis of the coordinate.
    * @param _axis new axis of the coordinate.
    */
   public void setAxis(DAxis _axis) 
   {
      axis_ = _axis;    
   }


   /** do nothing, since DCoord can't have child */
   public boolean addChild(IDItem item)
   {
     return false;
   }

   public void clear()
   {
   }

   /** @return 0 because DCoord can't have children */
   public int getChildCount()
   {
    return 0;
   }

  /** @return -1 because DCoord can't have child */
  public int getChildPosition(IDItem i)
  {
    return -1;
  }

  /** @return root item, the parent of parent of parent ... that haven't parent */
  public IDItem getRoot()
  {
    IDItem root = this;
    for( ; root.getParent()!=null; root = root.getParent() );
    return root;
  }

  /** @return null because DCoord can't have child */
  public IDItem getFirstChild()
  {
    return null;
  }

  /** @return null because DCoord can't have child */
  public IDItemIterator getIterator()
  {
    return null;
  }

  /** @return null because DCoord can't have child */
  public IDItem getLastChild()
  {
    return null;
  }

  /** @return next item */
  public IDItem getNext()
  {
    return next_;
  }

  /** @return parent item of DCoord */
  public IDItem getParent()
  {
    return parent_;
  }

  /** @return paren'ts applied style or null (because DCoord haven't their own style...) */
  public IDStyle getAppliedStyle()
  {
    if( parent_ == null ) return null;
    return parent_.getAppliedStyle();
  }

  /** Do nothing, because DCoord can't have child 
   * @return false;
   */
  public boolean insertChild(IDItem item, IDItem after)
  {
    return false;
  }

  /** @return false because DCoord can't have child. */
  public boolean isContainer()
  {
    return false;
  }

  /** Do nothing because DCoord can't have child */
  public boolean removeChild(IDItem item)
  {
    return false;
  }

  /** Change next item of DCoord */
  public void setNext(IDItem i)
  {
    next_ = i;    
  }

  /** Change parent item of DCoord */
  public void setParent(IDItem p)
  {
    parent_ = p;    
  }

  /** Do nothing because DCoord can't have style, apply style on DPoint or DCurve. */
  public void setStyle(IDStyle style)
  {    
  }
  
  /** Do nothing because DCoord can't have style, apply style on DPoint or DCurve. */ 
  public IDStyle getStyle()
  {    
    return null;
  }
}
