/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DCoordObject.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;


/**
 * An Object coordinate on an axis, designed to be a child of a DPoint.
 * You're responsible that the stored object is suitable for DAxis data class.
 * Use this IDCoord implementation to store Date coordinate, in this case value
 * is an instance of java.util.Date.
 * 
 * @see DPoint 
 * @see DAxis
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DCoordObject extends DCoordAbstract
{
   private Object value_;
   
   /**
    * Create coordinate on an axis.
    * @param a axis of the coordinate
    * @param v value of coordinate, a convenient class for DAxis data class.
    */
   public DCoordObject(DAxis a, Object v) 
   {
     super( a );
     value_ = v;    
   }
   
   /**
    * Create unusable unknown coordinate on an inexistent axis.
    * Becarefull using this constructor, you mus provide axis/value
    * calling setAxis(), setValue().
    */
   public DCoordObject() 
   {
     value_=null; 
   }
   
   /**
    * @return current value directly.
    * @see #getValue
    */
   public Object getValue( Object _p )
   {
     return value_;
   }
   
   /**
    * Change the value of the coordinate (no clone nor copy is done).
    * @param _value new value of the coordinate.
    */
   public void setValue( Object _value ) 
   {
      value_ = _value;    
   }

}
