/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DCurve.java,v 1.7 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;

import org.eclipse.tptp.platform.report.drawutil.internal.DSymbolRegistry;
import org.eclipse.tptp.platform.report.drawutil.internal.ISymbol;


/**
 * A curve is the parent of one or several points, can have a name.
 * A curve have also type: BAR/LINE/POINTS/SECTOR,
 * this type is only used in case of multi-curve-type graphic, and may
 * be understand as a "preferred" type rather than "required" type.
 * @see DPoint
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DCurve extends DItemContainer 
{
   
   /**
    * curve is preferred to be bars, used by T_XY and T_SERIES3D graphic types.
    */
   public static final String T_BAR = "T_BAR.DCurve.core.jscrib"; //$NON-NLS-1$
   
   /**
    * curve is preferred to be line, used by T_XY and T_SERIES3D graphic types.
    */
   public static final String T_LINE = "LINE.DCurve.core.jscrib"; //$NON-NLS-1$
   
   /**
    * curve is preferred to be points, for T_XY and T_SERIES3D graphic type,
    * point shape can be redefined using P_SYMBOL property (for T_XY only).
    */
   public static final String T_POINTS = "POINT.DCurve.core.jscrib"; //$NON-NLS-1$
   
   /**
    * curve is preferred to be line <b>and</b> points, for T_XY graphic type,
    * point shape can be redefined using P_SYMBOL property.
    */
   public static final String T_LINE_POINTS = "LINE_POINT.DCurve.core.jscrib"; //$NON-NLS-1$

   /**
    * curve is preferred to be sectors
    */
   public static final String T_SECTOR = "SECTOR.DCurve.core.jscrib"; //$NON-NLS-1$
   
   /**
    * Used in T_XY graphic type.
    * Curve is defined as a T_LINE curve but render cumulate values of stacked line
    * which belongs from same Y axis. First stacked line define the base line, second one
    * add it's value to base line defining a base line a third stacked line can use.
    * This means that the order of stacked line is important (order in IDItem.getNext() chain ).
    * This curve type require that Y axis use numbers (@see DAxis).
    */
   public static final String T_STACKED_LINE = "STACKED_LINE.DCurve.core.jscrib"; //$NON-NLS-1$
   /** 
    * Same as T_STACKED_LINE including symbols on each points of curve.
    */
   public static final String T_STACKED_LINE_POINTS = "STACKED_LINE_POINTS.DCurve.core.jscrib"; //$NON-NLS-1$
   /**
    * Same as T_STACKED_LINE and fill the area above this curve and previous one
    * (or axis if it's the first curve).
    */
   public static final String T_STACKED_AREA_LINE = "STACKED_AREA_LINE.DCurve.core.jscrib"; //$NON-NLS-1$  
   /**
    * Same T_STACKED_AREA_LINE, including symbol on each points of curve.
    */
   public static final String T_STACKED_AREA_LINE_POINTS = "STACKED_AREA_LINE_POINTS.DCurve.core.jscrib"; //$NON-NLS-1$
   
   /**
    * curve is preferred to be a filled area (from this curve to axis).
    * Line of curve is also displayed. This type can be used into T_XY and T_SERIES3D graphic types.
    */
   public static final String T_AREA_LINE="AREA_LINE.DCurve.core.jscrib"; //$NON-NLS-1$
   /**
    * same as T_AREA_LINE include symbol on each points of curve.
    */
   public static final String T_AREA_LINE_POINTS="AREA_LINE_POINTS.DCurve.core.jscrib"; //$NON-NLS-1$

   /**
    * Used in T_XY graphic type.
    * Curve is defined with points using 5 coordinates.
    * - one coordinate must belong from X axis.
    * - four coordinate must belong from Y axis.
    * The fourth Y coordinate are <b>ordered</b>:
    * - first is the open value of candle
    * - second is the highest value of candle
    * - third is the lowest value of candle
    * - fourth is the close value of candle.
    * First and fourth value define the body of the candle.  If close value is greater than
    * open value the body is filled using style's background of curve and the candle lines use
    * style's foreground color.
    * If the close value is lower than open value the colors are reversed: the user can
    * see the difference between raising or falling candle.
    * Note that P_CS_FALL_COLOR property can be used to change falling body color of candlestick.
    */
   public static final String T_CANDLESTICK = "CANDLESTICK.DCurve.core.jscrib"; //$NON-NLS-1$
   /**
    * Used in T_XY graphic type.
    * Curve is define exactly as T_CANDLESTICK, only the drawing differ.
    * This curve use only foreground value to draw a vertical line between highest and
    * lowest values. The open value is drawn on the left of vertical line using horizontal one,
    * and close value is drawn on the right.
    */
   public static final String T_CANDLESTICK_LINE = "CANDLESTICK_LINE.DCurve.core.jscrib"; //$NON-NLS-1$

   /**
    * Used in T_XY graphic type.
    * Curve rendered using vertical independant bar, the vertical center of bar is defined
    * by X coordinate and Y coordinate define the height of the bar.  The bar width is choosen
    * by render and have no particular sense. 
    */
   public static final String T_VBAR = "VBAR.DCurve.core.jscrib"; //$NON-NLS-1$

   /**
    * Used in T_XY graphic type.
    * Each points are rendered using a filled circle (using background color), radius comes from
    * a third DAxis which must not be "x" not "y" not "y2" axis. 
    */
   public static final String T_BUBBLE="BUBBLE.DCurve.core.jscrib"; //$NON-NLS-1$

   /**
    * Used in T_XY graphic type.
    * Each points are rendered using an empty circle (transparent), circle color
    * is set by point's style background color.
    * a third DAxis which must not be "x" not "y" not "y2" axis. 
    */
   public static final String T_CIRCLE="CIRCLE.DCurve.core.jscrib"; //$NON-NLS-1$


   /**
    * Used in T_SERIES3D graphic type.
    * Curve use for each point a bar with 45 degree rotation.
    */
   public static final String T_BAR2 = "BAR2.DCurve.core.jscrib"; //$NON-NLS-1$
   
   /** 
    * Used in T_SERIES3D graphic type.
    * Curve use for each point a pyramid.
    */
   public static final String T_PYRAMID = "PYRAMID.DCurve.core.jscrib"; //$NON-NLS-1$
   
   /** 
    * Used in T_SERIES3D graphic type.
    * Curve use for each point a faceted cylinder.
    */
   public static final String T_CYLINDER = "CYLINDER.DCurve.core.jscrib"; //$NON-NLS-1$
   
   /**
    * Property key to associate a symbol to this curve. value is a string
    * that symbol registry knows.
    * Symbol are displayed in legend area of graphic, and can be used in
    * T_POINTS curve.
    * @see #T_POINTS
    */
   public static final String P_SYMBOL = "SYMBOL.DCurve.core.jscrib"; //$NON-NLS-1$
   
   /**
    * Property key to set color used to draw the curve.
    * The object must be an instance of IDColor interface.
    */
   public static final String P_COLOR = "P_COLOR.DCurve.core.jscrib"; //$NON-NLS-1$
   
   /**
    * Property key to set color used for candlestick body when the candlestick is known
    * to be "falling" (ie: closing value is lower than opening one).
    * The object must be an instance of IDColor interface.
    */
   public static final String P_CS_FALL_COLOR = "CS_FALL_COLOR.DCurve.core.jscrib"; //$NON-NLS-1$
   
   /**
    * Property key for a positive double applyies on T_PIE3D graphic type, and requesting
    * a shift of sectors. Obviously if there only one sector in graphic no shift can be processed.
    * In other hand, all sectors of a curve are shifted same way (as property applies on curve 
    * and not on a point).
    * By default no shift is applyied on sectors.
    */
   public static final String P_SHIFT_SECTORS = "SHIFT_SECTOR.DCurve.core.jscrib"; //$NON-NLS-1$
   /**
    * Property key as string to store the curve id.
    * Only activated for the SVG generation
    */
   public static final String P_ID = "P_ID.DCurve.core.jscrib"; //$NON-NLS-1$
   
   /** Name of the curve */
   private String name_;
   /** Type of the curve, see T_xxxx constants */
   private String type_;
   /** Property store provided for curve behavior extensions */
   private DPropertyStore properties_;
   /** Tooltip for the curve */
   private String tooltip_;
  
   
   /**
    * Creates an empty unamed curve having preferred type LINE.
    */
   public DCurve() 
   {
     name_=null;
     type_=T_LINE;    
   }
   
   /**
    * @return  the name of the curve, can be null.
    */
   public String getName() 
   {
      return name_;    
   }
   
   /**
    * Change the name of the curve.
    * @param _name new name for the curve.
    */
   public void setName(String _name) 
   {
      name_ = _name;    
   }
   
   /**
    * @return  the preferred type for the curve.
    */
   public String getType() 
   {
      return type_;    
   }
   
   /**
    * Changes the preferred type for the curve.
    * @param _type new preferred type.
    */
   public void setType(String _type) 
   {
      type_ = _type;    
   }
   
   /**
    * @return true is curve type is equals to given one.
     */
   public boolean isType(String _ct) 
   {
     if( _ct == type_ ) return true;
     if( _ct == null ) return false;
     return _ct.equals( type_ );    
   }
   
   /** 
    * @return property store associated with curve
    */
   public DPropertyStore getProperties()
   {
     if( properties_==null ) properties_=new DPropertyStore();
     return properties_;
   }
   
   /**
    * Replaces current property store, with current one.
    */
   public void setProperties( DPropertyStore s )
   {
     properties_ = s;
   }
   
   /**
    * @return symbol associated with this curve, if none, a Square.
    */
   public ISymbol getSymbol()
   {
     String name = null;
     try{
       if( properties_!=null ) name = (String)properties_.get(P_SYMBOL);
     }
     catch(Exception e){}
     ISymbol s = DSymbolRegistry.GetCoreSymbol( name );
     if( s==null ) s = DSymbolRegistry.GetSquare();
     return s;
   }
   
   /**
    * @return true if curve type is associated to a symbol.
    */
   public boolean useSymbol()
   {
     if( type_==null ) return false;
     if( T_POINTS.equals( type_ ) ) return true;
     if( T_LINE_POINTS.equals( type_ ) ) return true;
     if( T_AREA_LINE_POINTS.equals( type_ ) ) return true;
     if( T_STACKED_LINE_POINTS.equals( type_ ) ) return true;
     if( T_STACKED_AREA_LINE_POINTS.equals( type_ ) ) return true;
     return false; 
   }

   /** @return the tooltip */
   public String getTooltip() {
       return tooltip_;
   }

   /** sets the tooltip */
   public void setTooltip(String tooltip_) {
       this.tooltip_ = tooltip_;
   }
   
   /** sets the style of the curve */
   public void setStyle(IDStyle s)
   {
       super.setStyle(s);
       if (s != null)
    	   getProperties().store(DCurve.P_COLOR, s.getForeColor());
   }
   
}
