/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DDocument.java,v 1.5 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;

import org.eclipse.tptp.platform.report.core.provisional.IChart;


/**
 * A DDocument is the class to use to create any document. This item is generally the
 * root item of a IDItem hierarchy.
 * You can add a title which will be used by the drivers to indicate the document which they are
 * currently processing or displaying (Printer Job,  tiltle window). 
 * DDocument support alignment,all the items added to the paragraph will be displayed 
 * by the driver in the specified alignment.
 * 
 * @see IDAlignment
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DDocument extends DAbstractParagraph implements IDDocument, IChart
{
   private String title;
   private String tag;
   
   
   /**
    * Creates a DDocument with a tag, a title and an alignment. 
    *  
    * @param tag of the DDocument
    * @param title of the DDocument
    * @param align is the alignment
    * 
    * @see IDAlignment
    */
   public DDocument(String tag, String title, int align) 
   {
   	super(align);
   	this.title = title;
   	setTag( tag );
   }
   
   /**
    * Creates a DDocument with an alignment.
    * The tag is <b>documentdef</b> by default
    * and the title is <b>unnamed</b>.
    * 
    * @see IDAlignment
    */
   public DDocument(int align) 
   {
   	super(align);
   	setTag( null );    
   	setTitle(null);
   }
   
   /**
    * Creates a DDocument with a tag and a title and a default alignment. 
    *  
    * @param tag of the DDocument
    * @param title of the DDocument
    */
   public DDocument(String tag, String title) 
   {
   	 super();
     this.title = title;
     setTag( tag );
   }
   
   /**
    * Creates a DDocument. The tag is <b>documentdef</b> by default
    * and the title is <b>unnamed</b>.
    */
   public DDocument() 
   {
   	 super();
     setTag( null );    
     setTitle(null);
   }
   
   /**
    * Access method for the title property.
    * 
    * @return   the current value of the title property
    */
   public java.lang.String getTitle() 
   {
    return title;    
   }
   
   /**
    * Sets the value of the title property. If the value is null the document
    * is named <b>unnamed</b> automatically.
    * 
    * @param aTitle the new value of the title property
    */
   public void setTitle(java.lang.String aTitle) 
   {
   	  title = aTitle==null ? "unnamed" : aTitle ;    
   }
   
   /**
    * Access method for the tag property.
    * 
    * @return   the current value of the tag property
    */
   public java.lang.String getTag() 
   {
    return tag;    
   }
   
   /**
    * Sets the value of the tag property. If the value is null the document
    * is named <b>documentdef</b> automatically.
    * 
    * @param aTag the new value of the tag property
    */
   public void setTag(java.lang.String aTag) 
   {
      tag = aTag==null ? "documentdef" : aTag ;    //$NON-NLS-1$
   }

   /** 
    * @return this
    * @see org.eclipse.tptp.platform.report.core.provisional.internal.IDDocument#getDocument()
    */
   public IDItem getDocument() {
    return this;
   }
   
}
