/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DEvent.java,v 1.3 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;


/**
 * This class provides event handler support for the item.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DEvent extends DItem {
    
    private String type =  DEvent.EVT_ONCLICK;
    private String handler;
    
    /** Called when the mouse button is clicked */
    public static final String EVT_ONCLICK = "onclick"; //$NON-NLS-1$
    /** Called when the mouse button is down */
    public static final String EVT_ONMOUSEDOWN = "onmousedown"; //$NON-NLS-1$
    /** Called when the mouse button is up */
    public static final String EVT_ONMOUSEUP = "onmouseup"; //$NON-NLS-1$
    /** Called when the mouse pointer is on the item */
    public static final String EVT_ONMOUSEOVER = "onmouseover"; //$NON-NLS-1$
    /** Called when the mouse pointer is moving over the item */
    public static final String EVT_ONMOUSEMOVE = "onmousemove"; //$NON-NLS-1$
    /** Called when the mouse pointer is leaving the item */
    public static final String EVT_ONMOUSEOUT = "onmouseout"; //$NON-NLS-1$
    /** Called when the item is loading  */
    public static final String EVT_ONLOAD = "onload"; //$NON-NLS-1$
    /** Called when the item is unloading  */
    public static final String EVT_ONUNLOAD = "onunload"; //$NON-NLS-1$
    /** Called when the item's drawing is cancelled */
    public static final String EVT_ONABORT = "onabort"; //$NON-NLS-1$
    /** Called when the an error occurs during the drawing */
    public static final String EVT_ONERROR = "onerror"; //$NON-NLS-1$
    /** Called when the item is resized */
    public static final String EVT_ONRESIZE = "onresize"; //$NON-NLS-1$
    /** Called when the item is scroolled */
    public static final String EVT_ONSCROLL = "onscroll"; //$NON-NLS-1$
    /** Called when a zoom is applied */
    public static final String EVT_ONZOOM = "onzoom"; //$NON-NLS-1$
    /** Called when the item aquires the focus */
    public static final String EVT_ONFOCUSIN = "onfocusin"; //$NON-NLS-1$
    /** Called when the item leaves the focus */
    public static final String EVT_ONFOCUSOUT = "onfocusout"; //$NON-NLS-1$
    /** Called when item is selected */
    public static final String EVT_ONACTIVATE = "onactivate"; //$NON-NLS-1$
    /** Called when the ??? */
    public static final String EVT_ONBEGIN = "onbegin"; //$NON-NLS-1$
    /** Called when the ??? */
    public static final String EVT_ONEND = "onend"; //$NON-NLS-1$
    /** Called when the ???  */
    public static final String EVT_ONREPEAT = "onrepeat"; //$NON-NLS-1$
    /** Called when a key is pressed and the item is selected */
    public static final String EVT_ONKEYPRESS = "onkeypress"; //$NON-NLS-1$
        
    /** creates a new event with ONCLICK type by default */
    public DEvent() {}
    
    /** creates a new event with type and handler */
    public DEvent(String type, String handler) {
        this.type = type;
        this.handler = handler;
    }
    
    /** returns the handler */
    public String getHandler() {
        return handler;
    }
    
    /** sets a handler associated wit the event type */
    public void setHandler(String handler) {
        this.handler = handler;
    }
    
    /** @return returns the type of the event. 
     * The value is defined above prefixed by 'EVT_'
     */
    public String getType() {
        return type;
    }
    
    /** sets the type of the event. 
     * The value is defined above prefixed by 'EVT_'
     */
    public void setType(String type) {
        this.type = type;
    }

    
}
