/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DFolder.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.core.internal;


/**
 * A folder contains three part, first a folder header which is the first IDItem child of folder,
 * second a body build from others children of folder, and a folder model.<BR>
 * Folder model (DFolderModel) contains two differents symbol used to display opened and closed folder
 * (including foreground and background symbol colors), and an 'indentated' property.<BR>
 * For example in a viewer, user can click on symbol to open/close folder.<BR>
 * If folder is closed the body is not displayed.
 *
 * @see DFolderModel
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DFolder extends DItemContainer
{
  protected boolean opened_;
  protected DFolderModel model_;
  
  /** Create an opened folder item */
  public DFolder()
  {
    opened_=true;
  }
  
  /** Create a folder using given open state */
  public DFolder( boolean _opened )
  {
    opened_=_opened;
  }
  
  /** Create an opened folder using given folder model */
  public DFolder( DFolderModel _model )
  {
    model_ = _model;
    opened_ = true;
  }
  
  /** Create a folder using given opened state and folder model */
  public DFolder( boolean _opened, DFolderModel _model )
  {
    model_ = _model;
    opened_ = _opened;
  }
  
  /** @return open state of this folder */
  public boolean isOpen() { return opened_; }
  
  /** Change current open state of this folder */
  public void setOpen( boolean _opened ) { opened_=_opened; }
  
  /** @return model used by this folder, or null for none (DFolderModel.GetDefault()) */
  public DFolderModel getFolderModel()
  {
    return model_;
  }
  
  /** Change model used by this folder */
  public void setFolderModel( DFolderModel _model )
  {
    model_ = _model;
  }
}
