/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DFolderModel.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.core.internal;

import org.eclipse.tptp.platform.report.drawutil.internal.DSymbolRegistry;
import org.eclipse.tptp.platform.report.drawutil.internal.ISymbol;

/**
 * Share common properties used by DFolder, opened and closed symbol 
 * (including foreground and background colors), and 'indented' state.<BR>
 * Default folder model can be retrieved calling DFolderModel.GetDefault() method.
 * 
 * @see DFolder, ISymbol
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DFolderModel
{
  protected ISymbol opened_symbol_l2r_, opened_symbol_r2l_;
  protected ISymbol closed_symbol_l2r_, closed_symbol_r2l_;
  protected boolean indented_;
  protected IDColor opened_fore_, opened_back_;
  protected IDColor closed_fore_, closed_back_;
  
  /** Create an empty folder model, call any set method to set model properties */
  public DFolderModel() {}
  
  /**
   * Create a folder model with indented property and opened/closed symbol.
   * Use same symbol for left-to-right and right-to-left layout.
   */
  public DFolderModel( boolean _indented, ISymbol _open, ISymbol _close )
  {
    indented_      = _indented;
    opened_symbol_l2r_ = _open;
    closed_symbol_l2r_ = _close;
    opened_symbol_r2l_ = _open;
    closed_symbol_r2l_ = _close;
  } 
  
  /**
   * Create a folder model with indented property and opened/closed symbol
   * (for left to right and right 2 left layout) 
   */
  public DFolderModel( boolean _indented, ISymbol _open_l2r, ISymbol _close_l2r, ISymbol _open_r2l, ISymbol _close_r2l )
  {
    indented_      = _indented;
    opened_symbol_l2r_ = _open_l2r;
    closed_symbol_l2r_ = _close_l2r;
    opened_symbol_r2l_ = _open_r2l;
    closed_symbol_r2l_ = _close_r2l;
  }  
  
  /** @return true is folder indent their body (on the right of symbol for left to right layout) */
  public boolean isIndented() { return indented_; }
  /** @return the symbol used for 'opened' state */
  public ISymbol getOpenedSymbol(boolean _l2r ) { return _l2r ? opened_symbol_l2r_ : opened_symbol_r2l_; }
  /** @return the symbol used for 'closed' state */
  public ISymbol getClosedSymbol(boolean _l2r ) { return _l2r ? closed_symbol_l2r_ : closed_symbol_r2l_; }
  /** @return the foreground color used for 'opened' state */  
  public IDColor getOpenedForeColor() { return opened_fore_; }
  /** @return the background color used for 'opened' state */  
  public IDColor getOpenedBackColor() { return opened_back_; }
  /** @return the foreground color used for 'closed' state */  
  public IDColor getClosedForeColor() { return closed_fore_; }
  /** @return the background color used for 'closed' state */  
  public IDColor getClosedBackColor() { return closed_back_; }
  
  /** Change current 'indented' property */
  public void setIndented(boolean b) { indented_=b; }
  /** change symbol used for 'opened' state */
  public void setOpenedSymbol( boolean _l2r, ISymbol s ) 
  { if(_l2r) opened_symbol_l2r_ = s; else opened_symbol_r2l_=s; }
  /** change symbol used for 'closed' state */
  public void setClosedSymbol( boolean _l2r, ISymbol s ) 
  { if(_l2r) closed_symbol_l2r_ = s; else closed_symbol_r2l_=s; }
  /** change symbol used for both 'opened' and 'closed' state and both left-to-right and right-to-left layout */
  public void setSymbol( ISymbol _open_l2r, ISymbol _close_l2r, ISymbol _open_r2l, ISymbol _close_r2l )
  {
    opened_symbol_l2r_ = _open_l2r;
    closed_symbol_l2r_ = _close_l2r;
    opened_symbol_r2l_ = _open_r2l;
    closed_symbol_r2l_ = _close_r2l;
  }
  /** change symbol used for both 'opened' and 'closed' state same symbol is used got both  left-to-right and right-to-left layout */
  public void setSymbol( ISymbol _open, ISymbol _close )
  {
    opened_symbol_l2r_ = _open;
    closed_symbol_l2r_ = _close;
    opened_symbol_r2l_ = _open;
    closed_symbol_r2l_ = _close;
  }
  /** Change foreground (line) color used for 'opened' state */
  public void setOpenedForeColor( IDColor _c ) { opened_fore_ = _c; }
  /** Change background (fill) color used for 'opened' state */
  public void setOpenedBackColor( IDColor _c ) { opened_back_ = _c; }
  /** Change foreground (line) color used for 'closed' state */
  public void setClosedForeColor( IDColor _c ) { closed_fore_ = _c; }
  /** Change background (fill) color used for 'closed' state */
  public void setClosedBackColor( IDColor _c ) { closed_back_ = _c; }
  
  /** keep default folder model instance, allocated on GetDefault() call */
  private static DFolderModel default_;
  
  /**
   * @return default folder model.
   */
  public static DFolderModel GetDefault()
  {
    if( default_==null ) 
    {
      default_ = new DFolderModel( false,
          DSymbolRegistry.GetDown(), DSymbolRegistry.GetRight(),
          DSymbolRegistry.GetDown(), DSymbolRegistry.GetLeft() );
    }
    return default_ ;
  }
}
