/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DFontRegistry.java,v 1.2 2008/05/23 14:11:48 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * A DFontRegistry is a container for IDFont. A DFontRegistry  
 * stores only one instance of IDFont if two IDFont are equals.
 * Before to store a new IDFont the registry checks if the IDFont doesn't exist in the
 * registry by calling the method <b>contains</b>.
 *
 * @see IDFont 
 * @see #contains
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DFontRegistry implements IDRegistry
{
   private ArrayList fonts;
   
   /**
    * Creates an empty Font Registry.
    */
   public DFontRegistry() 
   {
     fonts = new ArrayList();
   }
   
   
   /**
    * Deletes all font in the registry.
    */
   public void clear() 
   {
      fonts.clear();    
   }
   
   /**
    * Checks if the font is already stored in the registry.
    * @return true if font is stored by this registry.
    */
   public boolean contains( IDFont font )
   {
     //compare object in strict way to do trust equals()
     for( Iterator it=fonts.iterator(); it.hasNext(); )
     {
       if( it.next() == font ) return true;
     }
     return false;
   }
   
   /**
    * Puts the font in the registry only if font isn't already stored (and not null)
    */
   public void putFont( IDFont font ) 
   {
     if( font==null || contains(font) ) return ;
     fonts.add( font );
   }
   
   /**
    * Returns 
    * @return an iterator to access all fonts.
    */
   public Iterator iterator()
   {
     return fonts.iterator();
   }
   
   /** @return true if registry is empty, false if not */
   public boolean isEmpty()
   {
     return fonts.isEmpty();
   }
}
