/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DGraphic.java,v 1.10 2008/12/12 22:22:10 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;

import org.eclipse.tptp.platform.report.chart.internal.IXYSurfaceColorizer;
import org.eclipse.tptp.platform.report.core.provisional.IChart;

import com.ibm.icu.util.ULocale;

/**
 * Graphics purpose is to display chart in documents.
 * Graphics are parent of axis and curve, curve must contains at least one points
 * (or more, depending on curve type), and points define one or more coordinates
 * (associated to an axis), that's the data structure of a graphic.
 * Graphics have a type (see T_xxxx constants), used by drivers (ie graphic render)
 * to display data in differents way.
 * In addition display property (see D_xxxx constants) can be used to configure
 * graphic rendering (for instance including legend...)
 * Graphic may have a title.
 * In addition graphic can hold any property. A property is an object associated
 * with a key (String). By default DGraphic define any property key (se P_xxx 
 * constants)
 * but user can add it own property (very usefull for graphic render).
 * Few graphics type can have textuals labels, see DPoint class to know how to
 * set labels and which graphic type can have labels.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DGraphic extends DItemContainer implements IDRenderable, IDSizeableItem, IDParagraphItem, IChart
{
   private String title_;
   /** actual graphic type */
   private String graphic_type_ = T_HISTOGRAM;   
   /** Property store */
   protected DPropertyStore properties_;
      
   /**
    * graphic is made of flat sectors, require one axis, 1+ curve with 1+ points
    */
   public static final String T_SECTORS = "T_SECTORS.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * graphic made of vertical bar, require one axis, several DCurve and DPoint.
    * Each bar are rendered left to right.
    * You can apply P_THIN_BAR or/and P_3D property on this graphic type.
    */
   public static final String T_HISTOGRAM = "T_HISTOGRAM.DGraphic.core.jscrib"; //$NON-NLS-1$
   

   /**
    * graphic is a flat histogram using mixed values, means each point having same index from
    * curves are rendered together.
    * You can apply P_THIN_BAR or/and P_3D property on this graphic type.
    */
   public static final String T_HISTOGRAM_IM = "T_HISTOGRAM_IM.DGraphic.core.jscrib"; //$NON-NLS-1$

   /**
    * graphic is a flat histogram using mixed values, means each point having same index from
    * curves are rendered together. The Y axis is horizontal
    * You can apply P_THIN_BAR or/and P_3D property on this graphic type.
    */
   public static final String T_H_HISTOGRAM_IM = "T_H_HISTOGRAM_IM.DGraphic.core.jscrib"; //$NON-NLS-1$

   
   /**
    * graphic is made of fixed angle sectors but ray depends on points values
    */
   public static final String T_HISTORS = "T_HISTORS.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * default values for graphic_type_
    * 2D plan, required two axis support curve type LINE,BAR,POINTS.
    * Note on T_BAR curve type: as it's a XY graphic, x coordinate is used as a
    * width of the bar, and y as the height. first bar of curve start on the left of graphic,
    * and other take place left to right.
    * This graphic type requier two axis named "x" and "y", a third one named "y2" can be used
    * for a secondary Y axis rendered on the right side of the graphic.
    */
   public static final String T_XY = "T_XY.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * 3D graphic displaying curves, require 3 axis.
    * Those graphics can use number, dates, ... and scales.
    * If your graphics contains several data, this is a good idea to set P_MIN and P_MAX
    * property for each axis, this will save time.
    */
   public static final String T_XYZ = "T_XYZ.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * 3D graphic displaying a surface, require 3 axis, 2+ curves with same number of points .
    * @see #T_XYZ
    */
   public static final String T_WIREFRAME = "T_WIREFRAME.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * graphic is made of sectors displayed as simulated 3D elevation (see T_SECTORS)
    */
   public static final String T_SECTORS3D = "T_SECTORS3D.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * graphic made of horizontal bars, this graphic type contains four kind of graphics:
    * <LI>simple histogram bars: use une DAxis, several DCurve and DPoint with one DCoord by point
    * <LI>one chart begin-end bars: use one DAxis, several DCurve/DPoint, by set two DCoord by points
    * <LI>two horizontal bars: same as simple horizontal bars, but use two DAxis (one by chart).
    * <LI>two chart begin-end: same as one chart begin-end but use two DAxis (one by chart).
    * Property P_THIN_BAR can be applied to this graphic type.
    */
   public static final String T_HBARS = "T_HBARS.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * Graphic made of vertical stacked bars. Each DPoint found at same index of DCurve are
    * rendered on above other.
    * You can apply P_THIN_BAR and/or P_3D property to this graphic type.
    * Because render have to summarize values of point, this graphic type must have
    * a DAxis that useNumbers() return true.
    */
   public static final String T_STACKBARS = "T_STACKBARS.DGraphic.core.jscrib"; //$NON-NLS-1$

   /**
    * Graphic made of vertical stacked bars. Each DPoint found at same index of DCurve are
    * rendered on above other. Y axis is horizontal
    * You can apply P_THIN_BAR and/or P_3D property to this graphic type.
    * Because render have to summarize values of point, this graphic type must have
    * a DAxis that useNumbers() return true.
    */
   public static final String T_H_STACKBARS = "T_H_STACKBARS.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   
   /**
    * Graphic showing a Meter. One axis is required, if min/max not set, defaults are 0..100
    * for axis using numbers.
    * The first curve defined needles, first point of this curve is the main needle which value
    * is displayed in the Meter, others point define extra-needle (you can set different foreground
    * color of those point's style to visually differenciate them).
    * First point of other curves are used to configure filled region under the needle (ie
    * if you want to display green,yellow,red color for examples, ...). 
    * Remember: by default legend is displayed, personnaly I prefer to not display legend
    * for Meter graphics, if you too, set P_SHOW_LEGEND property to false.
    */
   public static final String T_METER = "T_METER.DGraphic.core.jscrib"; //$NON-NLS-1$

   /**
    * Graphic made of real 3D bars, 3D lines (ribbon), others. Choose point of view using P_PHI and P_THETA
    * properties. See DCurve.T_xxx curve type for supported curves types (ir T_BAR, T_LINE,T_POINTS,...)
    * You can use P_THIN_BAR property to display thin bar or thin curve instead of side-by-side bars. 
    */
   public static final String T_SERIES3D = "T_SERIES3D.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * Graphic is a Pie chart using 3D projection, with free rotation.
    * Follow the definition of T_SECTORS for DCurve and DPoint definition.
    */
   public static final String T_PIE3D = "T_PIE3D.DGraphic.core.jscrib";  //$NON-NLS-1$
   /**
    * Graphic is a 3D Torus, with free rotation (similar to T_PIE3D but using a torus as volume).
    * Follow the definition of T_SECTORS for DCurve and DPoint definition.
    */
   public static final String T_TORUS3D = "T_TORUS3D.DGraphic.core.jscrib";  //$NON-NLS-1$
   
   /**
    * Graphic is a XY Surface with Z raising, rendered using 3D projection with free rotation.
    * This graphic need at least one IXYSurface object as children of DGraphic, and not the 
    * usual DCurve/DPoint/IDCoord trio. Pleas note this graphic doesn't use any accelerated
    * video card or smart mode, that why Surface should have reasonnable size to be rendered
    * correctly (depending on platform used).
    * (you can use DXYSurface implementation or define your own one).
    * A Z axis (DAxis with "z" name) can be set as child of DGraphic to render Z values,
    * but this is optional.
    * The following properties are supported: P_3D_HEIGHT, P_XYS_COLORIZER, P_XYS_LINE_X,
    * P_XYS_LINE_Y, P_XYZ_PHI, P_YZ_THETA, P_3D_SHADOW, P_3D_LIGHT,
    * P_XYS_COUNTOUR_LINE, P_XYS_CONTOUR_LINE_COLOR
    */
   public static final String T_XY_SURFACE="T_XY_SURFACE.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key, hold a Boolean value false to not display legend (otherwise the legend 
    * is displayed)
    */
   public static final String P_SHOW_LEGEND = "P_SHOW_LEGEND.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key, hold a Boolean value false to not display graphic title 
    * (otherwise the title is displayed)
    */
   public static final String P_SHOW_TITLE = "P_SHOW_TITLED.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for 'phi' (angle view for XYZ graphs), Float class if exists
    */
   public static final String P_XYZ_PHI = "P_XYZ_PHI.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for 'theta' (angle view for XYZ graphs), Float class if exists
    */
   public static final String P_XYZ_THETA = "P_XYZ_THETA.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property to force projection status on X axis, Boolean (default: true)
    */
   public static final String P_XYZ_XPROJ = "P_XYZ_XPROJ.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property to force projection status on Y axis, Boolean (default: true)
    */
   public static final String P_XYZ_YPROJ = "P_XYZ_YPROJ.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property to force projection status on Z axis, Boolean (default: true)
    */
   public static final String P_XYZ_ZPROJ = "P_XYZ_ZPROJ.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property to constraint the maximum height of graphic in pixel... (default none)
    */
   public static final String P_MAX_HEIGHT = "P_MAX_HEIGHT.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * property to constraint the minimum height of graphic in pixel... (default none)
    */
   public static final String P_MIN_HEIGHT = "P_MIN_HEIGHT.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * property to constraint the maximum width of graphic in pixel... (default none)
    */
   public static final String P_MAX_WIDTH = "P_MAX_WIDTH.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * property to constraint the minimum width of graphic in pixel... (default none)
    */
   public static final String P_MIN_WIDTH = "P_MIN_WIDTH.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * property to set a scale on the width of the graphic, scale is in 0..1, default is 1
    */
   public static final String P_WIDTH_SCALE = "P_WIDTH_SCALE.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * string property to set a color for the background.
    * null by default.
    */
   public static final String P_BACKCOLOR = "P_BACKCOLOR.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * property to set a scale on the height of the graphic, scale is in 0..1, default is 1
    */
   public static final String P_HEIGHT_SCALE = "P_HEIGHT_SCALE.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * boolean property to set thin bar, or connected bar.
    * Currently this property can be applyed to T_HISTOGRAM, T_HBARS and T_STACKBARS.
    */
   public static final String P_THIN_BAR = "P_THIN_BAR.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * boolean property to set "3D" effect on graphics (ie 3D bar in histograms).
    * Currently this property can be applyed to T_HISTOGRAM, and T_STACKBARS.
    */
   public static final String P_3D = "P_3D.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a string value which defines the chart id.
    * Only activated for the SVG generation.
    */
   public static final String P_ID = "P_ID.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a DAlignmentPair object controlling the layout and alignment of graphic title.
    * Primary alignment is the title layout and rotation or vertical style, secondary is the alignment
    * of the text.
    * Default Alignement is (TOP,HCENTER)
    * Example: DAlignmentPair(IDAlignment.LEFT|IDAlignment.ROTCCW90,IDAlignment.BOTTOM) for a
    * title on left, rotated to 90 counter clockwise, and at the bottom.
    */
   public static final String P_TITLE_LAYOUT = "P_TITLE_LAYOUT.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a string which defines the tooltip of the title 
    * Only activated for the SVG generation.
    */
   public static final String P_TITLE_TOOLTIP = "P_TITLE_TOOLTIP.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for an IDColor which defines the background color of the title 
    * Only activated for the SVG generation.
    */
   public static final String P_TITLE_BACKCOLOR = "P_TITLE_BACKCOLOR.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a string which defines the separator
    * Only activated for the SVG generation.
    */
   public static final String P_TITLE_WITH_SEPARATOR = "P_TITLE_WITH_SEPARATOR.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a List of DEvent object which defines the interaction on the chart title.
    * Only activated for the SVG generation.
    * @see DEvent
    */
   public static final String P_TITLE_EVENT_LIST = "P_TITLE_EVENT_LIST.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a string  which defines accessibility title required by the screen reader.
    * Only activated for the SVG generation.
    */
   public static final String P_TITLE_ACC_TITLE = "P_TITLE_ACC_TITLE.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * property key for a string  which defines title description required by the screen reader.
    * Only activated for the SVG generation.
    */
   public static final String P_TITLE_ACC_DESC = "P_TITLE_ACC_DESC.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a DAlignmentPair object controlling the layout and alignment of graphic legend.
    * Vertical, or rotated alignment are not used.
    * Default alignement if (RIGHT,VCENTER)
    * @see #P_SHOW_LEGEND
    */
   public static final String P_LEGEND_LAYOUT = "P_LEGEND_LAYOUT.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a integer defining the maximum space the legend can graphically take.
    * If legend has a LEFT/RIGHT layout, the limit is the width of graphic divided by P_LEGEND_LIMIT (default is 4).
    * If legend has a TOP/BOTTOM layout, the limit is the height of graphic divided by P_LEGEND_LIMIT (default is 8).
    * P_LEGEND_LIMIT must be an integer grater than 1.
    */
   public static final String P_LEGEND_LIMIT = "P_LEGEND_LIMIT.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a integer defining the width of the legend can graphically take.
    * The size is defined in pixel. By default the value is 100.
    * Only activated on SVG generation.
    */
   public static final String P_LEGEND_WIDTH = "P_LEGEND_WIDTH.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
	* property key for a string object which defines the legend location.
	* Only activated for the SVG generation.
	*/
   public static final String P_LEGEND_LOCATION = "P_LEGEND_LOCATION.DGraphic.core.jscrib"; //$NON-NLS-1$

   
   /**
    * property key for a integer defining the height of the legend can graphically take.
    * The size is defined in pixel. By default the value is 100.
    * Only activated on SVG generation.
    */
   public static final String P_LEGEND_HEIGHT = "P_LEGEND_HEIGHT.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a string which defines the label for the legend.
    * Only activated on SVG generation.
    */
   public static final String P_LEGEND_LABEL = "P_LEGEND_LABEL.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a string which defines the tooltip for the legend.
    * Only activated on SVG generation.
    */
   public static final String P_LEGEND_TOOLTIP = "P_LEGEND_TOOLTIP.DGraphic.core.jscrib"; //$NON-NLS-1$
  
   /**
    * property key for an IDColor which defines the background color for the legend.
    * Only activated on SVG generation.
    */
   public static final String P_LEGEND_BACKCOLOR = "P_LEGEND_BACKCOLOR.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a List of DEvent object which defines the interactions on the chart legend.
    * Only activated for the SVG generation.
    * @see DEvent
    */
   public static final String P_LEGEND_EVENT_LIST = "P_LEGEND_EVENT_LIST.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a string object which defines the legend title required by the screen reader.
    * Only activated for the SVG generation.
    */
   public static final String P_LEGEND_ACC_TITLE = "P_LEGEND_ACC_TITLE.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * property key for a string object which defines the legend description required by the screen reader.
    * Only activated for the SVG generation.
    */
   public static final String P_LEGEND_ACC_DESC = "P_LEGEND_ACC_DESC.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * property key for a string object which defines the legend id.
    * Only activated for the SVG generation.
    */
   public static final String P_LEGEND_ID = "P_LEGEND_ID.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * If property is set (true), the filled area of T_STACKED_AREA and T_AREA curves are
    * drawn below the axis lines, otherwise filled area are drawn above axis lines
    * (and can hidde them).
    */
   public static final String P_BACK_AREA = "P_AREA_ON_BACK.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for T_SECTORS(3D) graphic for a boolean driving the display or not
    * of values (and labels). Default value is true.
    * @since 1.2.1
    */
   public static final String P_SHOW_VALUES = "P_SHOW_VALUES.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for string value which defines if the value is displayed as a percentage.
    *  Default value is true.
    * Only activated for the SVG generation
    */
   public static final String P_SHOW_PERCENTAGE = "P_SHOW_PERCENTAGE.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a string value which defines the value format displayed in the chart.
    * Only activated for the SVG Generation
    */
   public static final String P_VALUE_FORMAT = "P_VALUE_FORMAT.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for the a boolean which the chart displays or not the border.
    * Default value is true.
    * Only activated for SVG generatin
    */
   public static final String P_SHOW_BORDER = "P_SHOW_BORDER.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for the a boolean which the chart displays or not the border.
    * Default value is true.
    * Only activated for SVG generatin
    */
   public static final String P_SHOW_PLOTAREA_BORDER = "P_SHOW_PLOTAREA_BORDER.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * property key for an IDColor which is the background color of the plot area.
    * Default value is null.
    * Only activated for SVG generatin
    */
   public static final String P_PLOTAREA_BACKCOLOR = "P_PLOTAREA_BACKCOLOR.DGraphic.core.jscrib";   //$NON-NLS-1$
   /**
    * property key for a positive integer to change margin used by default chart render.
    * By default 10 pixels is used (converted to used device if not a Display).
    * @since 1.2.1
    */
   public static final String P_MARGIN = "P_MARGIN.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * property key for a positive number to change height (DEF_3D_HEIGHT by default).
    * This property apply on T_PIE3D graphic type.<br>
    * Note: default value is 1.0 is this property is used in a T_XY_SURFACE graphic type.
    * @since 1.2.2
    */
   public static final String P_3D_HEIGHT = "P_3D_HEIGHT.DGraphic.core.jscrib"; //$NON-NLS-1$
   /** default value for P_3D_HEIGHT property */
   public static final double DEF_3D_HEIGHT=0.25;
   /**
    * property key for a float(double) number to change 3D graphic's shadow strength.
    * 0 means no shadow, 1 means shadow is Black, default value is DEF_3D_SHADOW.
    * This property apply on T_PIE3D, T_TORUS3D, T_SERIES3D graphic type.
    * @since 1.2.2
    */
   public static final String P_3D_SHADOW = "P_3D_SHADOW.DGraphic.core.jscrib"; //$NON-NLS-1$
   /** default value for P_3D_SHADOW property */
   public static final float DEF_3D_SHADOW = 0.5f;
   
   /**
    * property key for a float(double) number to change 3D graphic's light strength (close to specular light effect)
    * 0 means no light, 1 means light is White, default value is DEF_3D_LIGHT.
    * This property apply on T_PIE3D, T_TORUS3D, T_SERIES3D graphic type.
    * @since 1.2.2
    */
   public static final String P_3D_LIGHT = "P_3D_LIGHT.DGraphic.core.jscrib"; //$NON-NLS-1$
   /** default value for P_3D_LIGHT property */
   public static final float DEF_3D_LIGHT = 0.6f;
   
   /** 
    * property key for an instance of IXYSurfaceColorizer class, used by T_XY_SURFACE
    * graphic type to get surface colors. A colorizer is provider by default.
    * @see IXYSurfaceColorizer
    */
   public static final String P_XYS_COLORIZER="P_XYS_COLORIZER.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * property key for an integer (N) used by T_XY_SURFACE graphic type to render
    * line every N face of surfaces along X axis, 0 for none. Default is 0.
    * This property apply to T_XY_SURFACE graphic type.
    */
   public static final String P_XYS_LINE_X="P_XYS_LINE_X.DGraphic.core.jscrib";   //$NON-NLS-1$
   /**
    * property key for an integer (N) used by T_XY_SURFACE graphic type to render
    * line every N face of surfaces along Y axis, 0 for none. Default is 0.
    * This property apply to T_XY_SURFACE graphic type.
    */
   public static final String P_XYS_LINE_Y="P_XYS_LINE_Y.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * property key to draw contour line on T_XY_SURFACE graphic type.
    * This property can have several values:<br>
    * - String defined by DAxis.P_STEP_LINE to use same value of this property set
    *  in "z" axis of graphic. If no "z" axis is defined,no contour line are drawn.<br>
    * - float/double value defining delta between two consecutive contour line. This delta
    * comes from "z" axis if this axis exists, otherwise delta must have value between 0 a 1.<br>
    * - otherwise no contour line are drawn.<br>
    * Property P_XYZ_ZPROJ can be set to true in addition to this one to draw contour line
    * on top/bottom of 3D box (depending on point of view). In this case default value of
    * P_XYZ_ZPROJ is false.<br>
    * This property applies to T_XY_SURFACE graphic type.
    */
   public static final String P_XYS_CONTOUR_LINE="P_XYS_CONTOUR_LINE.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * property key to define color of contour line drawn by T_XY_SURFACE graphic type.
    * The object stored can be:<br>
    * - an integer to defining RGBA color for all lines.<br>
    * - an instance of IXYSurfaceColorizer to colorize lines with different colors (gradient)<br>.
    * - an instance of IDColor.<br>
    * - otherwise default color is RGBA.BLACK.<br>
    * This property applies to T_XY_SURFACE graphic type. 
    */
   public static final String P_XYS_CONTOUR_LINE_COLOR="P_XYS_CONTOUR_LINE_COLOR.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * property key to avoid filling of polygon in a T_XY_SURFACE. This property is a boolean,
    * with default value is "false" (polygon are filled). This property should be used when
    * P_XYS_CONTOUR_LINE engaged.<br>
    * This property applies to T_XY_SURFACE graphic type. 
    */
   public static final String P_XYS_NO_POLYGON="P_XYS_NO_POLYGON.DGraphic.core.jscrib"; //$NON-NLS-1$
   /**
    * property key for a string which represents the format version.
    * Only activated for the SVG generation. 
    */
   public static final String P_VERSION="P_VERSION.DGraphic.core.jscrib"; //$NON-NLS-1$
   
   /**
    * Creates an empty graphic.
    */
   public DGraphic() 
   {
      properties_ = new DPropertyStore();
   }
   
   /**
    * Access method for the widthScale property.
    * 
    * @return   the current value of the widthScale property
    */
   public float getWidthScale() 
   {
     return properties_.get( P_WIDTH_SCALE, 1.0f );
   }
   
   /**
    * Sets the value of the widthScale property.
    * 
    * @param aWidthScale the new value of the widthScale property
    */
   public void setWidthScale(float aWidthScale) 
   {
      properties_.store( P_WIDTH_SCALE, aWidthScale );
   }
   
   /**
    * Access method for the heightScale property.
    * 
    * @return   the current value of the heightScale property
    */
   public float getHeightScale() 
   {
     return properties_.get( P_HEIGHT_SCALE, 1.0f );
   }
   
   /**
    * Sets the value of the heightScale property.
    * 
    * @param aHeightScale the new value of the heightScale property
    */
   public void setHeightScale(float aHeightScale) 
   {
      properties_.store( P_HEIGHT_SCALE, aHeightScale );
   }
   
   /**
    * Access method for the title_ property.
    * 
    * @return   the current value of the title_ property
    */
   public String getTitle() 
   {
      return title_;    
   }
   
   /**
    * Sets the value of the title_ property.
    * 
    * @param aTitle_ the new value of the title_ property
    */
   public void setTitle(java.lang.String aTitle_) 
   {
      title_ = aTitle_;    
   }
   
   /**
    * Alias of getRenderableId.
    * Return graphic type identifier.
    * @return graphic type.
    */
   public final String getGraphicType() 
   { 
   	return getRenderableId();
   }
   
   /**
    * Alias of setRenderableId
    * Changes graphic type.
   */
   public final void setGraphicType(String _gt) 
   {
   	  setRenderableId(_gt);
   }
   
   /**
    * Return graphic type identifier.
    * @return graphic type.
    */
   public String getRenderableId() 
   { return graphic_type_;    
   }
   
   /**
    * Changes renderable id, ie: graphic type.
   */
   public void setRenderableId(String _gt) 
   {
     graphic_type_=_gt==null ? T_HISTOGRAM : _gt;    
   }
   
   /**
    * Alias of isRenderableId
    * @return true is graphic type is equals to given one.
    */
   public final boolean isGraphicType(String _gt) 
   {
   	  return isRenderableId(_gt);  
   }
   
   /**
    * @return true is graphic type is equals to given one.
    */
   public boolean isRenderableId(String _gt) 
   {
     if( _gt == null ) return false; // null is not a valid renderable id
     if( _gt.equals( graphic_type_ ) ) return true;
     return _gt.equals( graphic_type_ );    
   }
   
   /** @return property store associated with the graphic */
   public DPropertyStore getProperties() 
   {
     return properties_;
   }
   
   /**
    * Change current property store of graphic.
    * @param store the new property store.
    */
   public void setProperties(DPropertyStore store)
   {
     properties_ = store;
   }

   /**
    * @return true if current graphic type can be moved using P_XYZ_PHI and P_XYZ_THETA properties.
    */
   public boolean canMoves() { return CanMoves( this ); }
   
   /**
    * @return true if given graphic type can be moved using P_XYZ_PHI and P_XYZ_THETA properties.
    */
   public static boolean CanMoves( DGraphic graphic )
   {
     if( graphic==null ) return false;
     String id = graphic.getRenderableId();
     if( DGraphic.T_XYZ.equals( id )) return true;
     if( DGraphic.T_WIREFRAME.equals( id )) return true;
     if( DGraphic.T_SERIES3D.equals( id )) return true;
     if( DGraphic.T_PIE3D.equals( id )) return true;
     if( DGraphic.T_TORUS3D.equals( id )) return true;
     if( DGraphic.T_XY_SURFACE.equals( id )) return true;
     return false;
   }
   
   /**
    * Return the locale set to the chart. Searches the DI18N child node
    * and return the locale. Return the default locale if no DI18N child is
    * found
    * @return Locale
    */
   public ULocale getLocale() 
   { 
       DI18N child = (DI18N)getChildOfClass(DI18N.class);
       if (child ==null)
           return ULocale.getDefault();
       else
           return (new ULocale(child.getLanguage(), child.getCountry()));
   }
}
