/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DI18N.java,v 1.3 2008/05/23 14:11:48 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;

/**
 * This interface provides the common properties for the internatinaliszation
 * information.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DI18N extends DItem {
    
    private String language;
    private String country;
    private String textDirection = DI18N.DEF_LTR;
    private String resourceBundle;
    private String timezone;
     
    /** Value of textDirection Left to Right */
    public static final String DEF_LTR = "LTR"; //$NON-NLS-1$
    
    /** Value of textDirection Right to Left */
    public static final String DEF_RTL = "RTL"; //$NON-NLS-1$
    
    /** creates a new I18N object with null language, null country and
     * DI18N.TD_LTR text direction
     */
    public DI18N() {}
    
    /** creates a new I18N object with language, country and text direction
     */
    public DI18N(String language, String country, String td)
    {
        this.language = language;
        this.country = country;
        this.textDirection = td;
    }
    
    /** @return the country */
    public String getCountry() {
        return country;
    }
    
    /** sets the country */
    public void setCountry(String country) {
        this.country = country;
    }
    
    /** @return the language */
    public String getLanguage() {
        return language;
    }
    
    /** sets the language */
    public void setLanguage(String language) {
        this.language = language;
    }
    
    /** @return the text direction TD_LTR or TD_RTL */
    public String getTextDirection() {
        return textDirection;
    }
    
    /** sets the text direction, values are  TD_LTR or TD_RTL  */
    public void setTextDirection(String textDirection) {
        this.textDirection = textDirection;
    }
    
    /** @return the resource bundle */
    public String getResourceBundle() {
        return resourceBundle;
    }
    
    /** sets the resource bundle */
    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }
    
    /** @return the time zone for date definition (null by default) */
    public String getTimeZone() {
        return timezone;
    }
    
    /** Sets the time zone for date definition */
    public void setTimeZone(String timezone) {
        this.timezone = timezone;
    }
}
