/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DImage.java,v 1.2 2008/05/23 14:11:47 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.core.internal;


/**
 * This class provides a way to add images in a document.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DImage extends DItem implements IDSizeableItem, IDBasicItem, IDParagraphItem 
{
   
   /**
    * This value can be an URL
    */
   private String name;
   private float heightScale = 1.0f;
   private float widthScale = 1.0f;
   
   /**
    * Creates an image with its name reference. 
    * 
    * @param name location of the pixmap. name can be an URL.
    */
   public DImage(String name) 
   {
      setName( name );
   }
   
   /**
    * Creates an image with <i>unnamed</i> reference.
    */
   public DImage() 
   {
     setName(null);
   }
   
   /**
    * Access method for the name property.
    * 
    * @return   the current value of the name property
    */
   public String getName() 
   {
      return name;    
   }
   
   /**
    * Sets the value of the name property.
    * 
    * @param aName the new value of the name property
    */
   public void setName( String aName) 
   {
      name = aName==null ? "unnamed" : aName;    
   }
   
   /**
    * Access method for the heightScale property.
    * 
    * @return   the current value of the heightScale property
    */
   public float getHeightScale() 
   {
    return heightScale;    
   }
   
   /**
    * Sets the value of the heightScale property.
    * 
    * @param aHeightScale the new value of the heightScale property
    */
   public void setHeightScale(float aHeightScale) 
   {
      heightScale = aHeightScale;    
   }
   
   /**
    * Access method for the widthScale property.
    * 
    * @return   the current value of the widthScale property
    */
   public float getWidthScale() 
   {
    return widthScale;    
   }
   
   /**
    * Sets the value of the widthScale property.
    * 
    * @param aWidthScale the new value of the widthScale property
    */
   public void setWidthScale(float aWidthScale) 
   {
      widthScale = aWidthScale;    
   }
}
